/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OAdaptiveLock;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OReentrantResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ODatabasePoolAbstract<DB extends ODatabaseInternal>
extends OAdaptiveLock
implements OResourcePoolListener<String, DB>,
OOrientListener {
    private final HashMap<String, OReentrantResourcePool<String, DB>> pools = new HashMap();
    protected Object owner;
    private int maxSize;
    private int timeout;
    private volatile Timer evictionTask;
    private Evictor evictor;

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize) {
        this(iOwner, iMinSize, iMaxSize, OGlobalConfiguration.CLIENT_CONNECT_POOL_WAIT_TIMEOUT.getValueAsInteger(), OGlobalConfiguration.DB_POOL_IDLE_TIMEOUT.getValueAsLong(), OGlobalConfiguration.DB_POOL_IDLE_CHECK_DELAY.getValueAsLong());
    }

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize, long idleTimeout, long timeBetweenEvictionRunsMillis) {
        this(iOwner, iMinSize, iMaxSize, OGlobalConfiguration.CLIENT_CONNECT_POOL_WAIT_TIMEOUT.getValueAsInteger(), idleTimeout, timeBetweenEvictionRunsMillis);
    }

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize, int iTimeout, long idleTimeoutMillis, long timeBetweenEvictionRunsMillis) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.getValueAsInteger(), true);
        this.maxSize = iMaxSize;
        this.timeout = iTimeout;
        this.owner = iOwner;
        Orient.instance().registerListener(this);
        if (idleTimeoutMillis > 0L && timeBetweenEvictionRunsMillis > 0L) {
            this.evictionTask = new Timer();
            this.evictor = new Evictor(idleTimeoutMillis);
            this.evictionTask.schedule((TimerTask)this.evictor, timeBetweenEvictionRunsMillis, timeBetweenEvictionRunsMillis);
        }
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword) throws OLockException {
        return this.acquire(iURL, iUserName, iUserPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB acquire(String iURL, String iUserName, String iUserPassword, Map<String, Object> iOptionalParams) throws OLockException {
        OReentrantResourcePool<String, Object> pool;
        String dbPooledName = OIOUtils.getUnixFileName(iUserName + "@" + iURL);
        this.lock();
        try {
            pool = this.pools.get(dbPooledName);
            if (pool == null) {
                pool = new OReentrantResourcePool(this.maxSize, this);
            }
            this.pools.put(dbPooledName, pool);
        }
        finally {
            this.unlock();
        }
        ODatabaseInternal db = (ODatabaseInternal)pool.getResource(iURL, this.timeout, iUserName, iUserPassword, iOptionalParams);
        return (DB)db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections(String url, String userName) {
        OReentrantResourcePool<String, DB> pool;
        String dbPooledName = OIOUtils.getUnixFileName(userName + "@" + url);
        this.lock();
        try {
            pool = this.pools.get(dbPooledName);
        }
        finally {
            this.unlock();
        }
        if (pool == null) {
            return this.maxSize;
        }
        return pool.getMaxResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCreatedInstances(String url, String userName) {
        String dbPooledName = OIOUtils.getUnixFileName(userName + "@" + url);
        this.lock();
        try {
            OReentrantResourcePool<String, DB> pool = this.pools.get(dbPooledName);
            if (pool == null) {
                int n = 0;
                return n;
            }
            int n = pool.getCreatedInstances();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnections(String url, String userName) {
        OReentrantResourcePool<String, DB> pool;
        String dbPooledName = OIOUtils.getUnixFileName(userName + "@" + url);
        this.lock();
        try {
            pool = this.pools.get(dbPooledName);
        }
        finally {
            this.unlock();
        }
        if (pool == null) {
            return 0;
        }
        return pool.getAvailableResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInCurrentThread(String url, String userName) {
        OReentrantResourcePool<String, DB> pool;
        String dbPooledName = OIOUtils.getUnixFileName(userName + "@" + url);
        this.lock();
        try {
            pool = this.pools.get(dbPooledName);
        }
        finally {
            this.unlock();
        }
        if (pool == null) {
            return 0;
        }
        return pool.getConnectionsInCurrentThread(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DB iDatabase) {
        OReentrantResourcePool<String, DB> pool;
        iDatabase.declareIntent(null);
        String dbPooledName = iDatabase.getUser().getName() + "@" + iDatabase.getURL();
        this.lock();
        try {
            pool = this.pools.get(dbPooledName);
        }
        finally {
            this.unlock();
        }
        if (pool == null) {
            throw new OLockException("Cannot release a database URL not acquired before. URL: " + iDatabase.getName());
        }
        if (pool.returnResource(iDatabase)) {
            this.notifyEvictor(dbPooledName, iDatabase);
        }
    }

    public DB reuseResource(String iKey, DB iValue) {
        return iValue;
    }

    public Map<String, OReentrantResourcePool<String, DB>> getPools() {
        this.lock();
        try {
            Map<String, OReentrantResourcePool<String, DB>> map = Collections.unmodifiableMap(this.pools);
            return map;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock();
        try {
            if (this.evictionTask != null) {
                this.evictionTask.cancel();
            }
            for (Map.Entry<String, OReentrantResourcePool<String, DB>> pool : this.pools.entrySet()) {
                for (ODatabaseInternal db : pool.getValue().getResources()) {
                    pool.getValue().close();
                    try {
                        OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", db.getName());
                        ((ODatabasePooled)((Object)db)).forceClose();
                        OLogManager.instance().debug((Object)this, "OK", db.getName());
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Error: %d", e.toString());
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void remove(String iName, String iUser) {
        this.remove(iUser + "@" + iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String iPoolName) {
        this.lock();
        try {
            OReentrantResourcePool<String, DB> pool = this.pools.remove(iPoolName);
            if (pool != null) {
                for (ODatabaseInternal db : pool.getResources()) {
                    OStorage stg = db.getStorage();
                    if (stg == null || stg.getStatus() != OStorage.STATUS.OPEN) continue;
                    try {
                        OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", db.getName());
                        ((ODatabasePooled)((Object)db)).forceClose();
                        OLogManager.instance().debug((Object)this, "OK", db.getName());
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Error: %d", e.toString());
                    }
                }
                pool.close();
            }
        }
        finally {
            this.unlock();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void onStorageRegistered(OStorage iStorage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStorageUnregistered(OStorage iStorage) {
        String storageURL = iStorage.getURL();
        this.lock();
        try {
            HashSet<String> poolToClose = null;
            for (Map.Entry<String, OReentrantResourcePool<String, DB>> e : this.pools.entrySet()) {
                int pos = e.getKey().indexOf("@");
                String dbName = e.getKey().substring(pos + 1);
                if (!storageURL.equals(dbName)) continue;
                if (poolToClose == null) {
                    poolToClose = new HashSet<String>();
                }
                poolToClose.add(e.getKey());
            }
            if (poolToClose != null) {
                for (String pool : poolToClose) {
                    this.remove(pool);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    private void notifyEvictor(String poolName, DB iDatabase) {
        if (this.evictor != null) {
            this.evictor.updateIdleTime(poolName, iDatabase);
        }
    }

    class Evictor
    extends TimerTask {
        private HashMap<String, Map<DB, Long>> evictionMap = new HashMap();
        private long minIdleTime;

        public Evictor(long minIdleTime) {
            this.minIdleTime = minIdleTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OLogManager.instance().debug((Object)this, "Running Connection Pool Evictor Service...", new Object[0]);
            ODatabasePoolAbstract.this.lock();
            try {
                for (Map.Entry pool : this.evictionMap.entrySet()) {
                    Map poolDbs = pool.getValue();
                    Iterator iterator = poolDbs.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OReentrantResourcePool oResourcePool;
                        Map.Entry db = iterator.next();
                        if (System.currentTimeMillis() - db.getValue() < this.minIdleTime || (oResourcePool = (OReentrantResourcePool)ODatabasePoolAbstract.this.pools.get(pool.getKey())) == null) continue;
                        OLogManager.instance().debug((Object)this, "Closing idle pooled database '%s'...", ((ODatabaseInternal)db.getKey()).getName());
                        ((ODatabasePooled)db.getKey()).forceClose();
                        oResourcePool.remove(db.getKey());
                        iterator.remove();
                    }
                }
            }
            finally {
                ODatabasePoolAbstract.this.unlock();
            }
        }

        public void updateIdleTime(String poolName, DB iDatabase) {
            Map pool = this.evictionMap.get(poolName);
            if (pool == null) {
                pool = new HashMap();
                this.evictionMap.put(poolName, pool);
            }
            pool.put(iDatabase, System.currentTimeMillis());
        }
    }
}

