/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;

public class ODatabaseFactory {
    final WeakHashMap<ODatabaseInternal<?>, Thread> instances = new WeakHashMap();

    public synchronized List<ODatabase<?>> getInstances(String iDatabaseName) {
        ArrayList result = new ArrayList();
        for (ODatabase oDatabase : this.instances.keySet()) {
            if (oDatabase == null || !oDatabase.getName().equals(iDatabaseName)) continue;
            result.add(oDatabase);
        }
        return result;
    }

    public synchronized ODatabase<?> register(ODatabaseInternal<?> db) {
        this.instances.put(db, Thread.currentThread());
        return db;
    }

    public synchronized void unregister(ODatabaseInternal<?> db) {
        this.instances.remove(db);
    }

    public synchronized void unregister(OStorage iStorage) {
        for (ODatabaseInternal<?> db : new HashSet(this.instances.keySet())) {
            if (db == null || db.getStorage() != iStorage) continue;
            db.close();
            this.instances.remove(db);
        }
    }

    public synchronized void shutdown() {
        if (this.instances.size() > 0) {
            OLogManager.instance().debug(null, "Found %d databases opened during OrientDB shutdown. Assure to always close database instances after usage", this.instances.size());
            for (ODatabase oDatabase : new HashSet(this.instances.keySet())) {
                if (oDatabase instanceof ODatabaseDocumentTx) {
                    ((ODatabaseDocumentTx)oDatabase).setCurrentDatabaseInThreadLocal();
                }
                if (oDatabase == null || oDatabase.isClosed()) continue;
                oDatabase.close();
            }
        }
    }

    public ODatabaseDocumentTx createDatabase(String iType, String url) {
        if (iType.equals("graph")) {
            return new ODatabaseDocumentTx(url){

                @Override
                public <THISDB extends ODatabase> THISDB create() {
                    Object db = super.create();
                    ODatabaseFactory.this.checkSchema((ODatabase<?>)db);
                    return (THISDB)db;
                }
            };
        }
        return new ODatabaseDocumentTx(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(ODatabase<?> iDatabase) {
        OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED);
        try {
            iDatabase.getMetadata().getSchema().getOrCreateClass("ORIDs");
            OClass vertexBaseClass = iDatabase.getMetadata().getSchema().getClass("V");
            OClass edgeBaseClass = iDatabase.getMetadata().getSchema().getClass("E");
            if (vertexBaseClass == null) {
                vertexBaseClass = iDatabase.getMetadata().getSchema().createClass("V");
                vertexBaseClass.setOverSize(2.0f);
            }
            if (edgeBaseClass == null) {
                iDatabase.getMetadata().getSchema().createClass("E");
            }
        }
        finally {
            OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.DEFAULT);
        }
    }
}

