/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.compression.impl;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompression;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class OZIPCompressionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compressDirectory(String sourceFolderName, OutputStream output, String[] iSkipFileExtensions, OCommandOutputListener iOutput, int compressionLevel) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(output);
        zos.setComment("OrientDB Backup executed on " + new Date());
        try {
            zos.setLevel(compressionLevel);
            int n = OZIPCompressionUtil.addFolder(zos, sourceFolderName, sourceFolderName, iSkipFileExtensions, iOutput);
            return n;
        }
        finally {
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressDirectory(InputStream in, String out, OCommandOutputListener iListener) throws IOException {
        File outdir = new File(out);
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    OZIPCompressionUtil.mkdirs(outdir, name);
                    continue;
                }
                String dir = OZIPCompressionUtil.getDirectoryPart(name);
                if (dir != null) {
                    OZIPCompressionUtil.mkdirs(outdir, dir);
                }
                OZIPCompressionUtil.extractFile(zin, outdir, name, iListener);
            }
        }
        finally {
            zin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipInputStream in, File outdir, String name, OCommandOutputListener iListener) throws IOException {
        if (iListener != null) {
            iListener.onMessage("\n- Uncompressing file " + name + "...");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        try {
            OIOUtils.copyStream(in, out, -1L);
        }
        finally {
            out.close();
        }
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String getDirectoryPart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addFolder(ZipOutputStream zos, String folderName, String baseFolderName, String[] iSkipFileExtensions, OCommandOutputListener iOutput) throws IOException {
        int total = 0;
        File f = new File(folderName);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] f2 = f.listFiles();
                for (int i = 0; i < f2.length; ++i) {
                    total += OZIPCompressionUtil.addFolder(zos, f2[i].getAbsolutePath(), baseFolderName, iSkipFileExtensions, iOutput);
                }
            } else {
                String entryName = folderName.substring(baseFolderName.length() + 1, folderName.length());
                if (iSkipFileExtensions != null) {
                    for (String skip : iSkipFileExtensions) {
                        if (!entryName.endsWith(skip)) continue;
                        return 0;
                    }
                }
                long begin = System.currentTimeMillis();
                if (iOutput != null) {
                    iOutput.onMessage("\n- Compressing file " + entryName + "...");
                }
                ZipEntry ze = new ZipEntry(entryName);
                zos.putNextEntry(ze);
                try {
                    FileInputStream in = new FileInputStream(folderName);
                    try {
                        OIOUtils.copyStream(in, zos, -1L);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (iOutput != null) {
                        iOutput.onMessage("error: " + e);
                    }
                    OLogManager.instance().error(OZIPCompression.class, "Cannot compress file: %s", (Throwable)e, folderName);
                    throw e;
                }
                finally {
                    zos.closeEntry();
                }
                if (iOutput != null) {
                    long ratio = ze.getSize() > 0L ? 100L - ze.getCompressedSize() * 100L / ze.getSize() : 0L;
                    iOutput.onMessage("ok size=" + OFileUtils.getSizeAsString(ze.getSize()) + " compressedSize=" + ze.getCompressedSize() + " ratio=" + ratio + "%% elapsed=" + OIOUtils.getTimeAsString(System.currentTimeMillis() - begin) + "");
                }
                ++total;
            }
        } else {
            throw new IllegalArgumentException("Directory " + folderName + " not found");
        }
        return total;
    }
}

