/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseMultiValueProcess;
import com.orientechnologies.orient.core.command.traverse.OTraversePath;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class OTraverseRecordProcess
extends OTraverseAbstractProcess<ODocument> {
    private final OTraversePath path;

    public OTraverseRecordProcess(OTraverse iCommand, ODocument iTarget, OTraversePath parentPath) {
        super(iCommand, iTarget);
        this.path = parentPath.append(iTarget);
    }

    @Override
    public OIdentifiable process() {
        Object conditionResult;
        if (this.target == null) {
            return this.drop();
        }
        if (((OTraverse)this.command).getContext().isAlreadyTraversed((OIdentifiable)this.target)) {
            return this.drop();
        }
        if (((ODocument)this.target).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                ((ODocument)this.target).reload();
            }
            catch (ORecordNotFoundException e) {
                return this.drop();
            }
        }
        if (((OTraverse)this.command).getPredicate() != null && (conditionResult = ((OTraverse)this.command).getPredicate().evaluate((ORecord)this.target, null, ((OTraverse)this.command).getContext())) != Boolean.TRUE) {
            return this.drop();
        }
        ((OTraverse)this.command).getContext().addTraversed((OIdentifiable)this.target);
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Object cfgFieldObject : ((OTraverse)this.command).getFields()) {
            String cfgField = cfgFieldObject.toString();
            if ("*".equals(cfgField) || "ALL()".equalsIgnoreCase(cfgField) || "ANY()".equalsIgnoreCase(cfgField)) {
                Collections.addAll(fields, ((ODocument)this.target).fieldNames());
                break;
            }
            int pos = cfgField.indexOf(46);
            if (pos > -1) {
                String className;
                OClass cls = ODocumentInternal.getImmutableSchemaClass((ODocument)this.target);
                if (cls == null || !cls.isSubClassOf(className = cfgField.substring(0, pos))) continue;
                cfgField = cfgField.substring(pos + 1);
                fields.add(cfgField);
                continue;
            }
            fields.add(cfgFieldObject);
        }
        this.processFields(fields.iterator());
        if (((ODocument)this.target).isEmbedded()) {
            return null;
        }
        return (OIdentifiable)this.target;
    }

    /*
     * WARNING - void declaration
     */
    private void processFields(Iterator<Object> target) {
        ODocument doc = (ODocument)this.target;
        while (target.hasNext()) {
            void var5_5;
            OTraverseAbstractProcess subProcess;
            Object field = target.next();
            Object fieldValue = field instanceof OSQLFilterItem ? ((OSQLFilterItem)field).getValue(doc, null, null) : doc.rawField(field.toString());
            if (fieldValue == null) continue;
            if (fieldValue instanceof Iterator || OMultiValue.isMultiValue(fieldValue)) {
                Iterator<Object> coll = OMultiValue.getMultiValueIterator(fieldValue);
                subProcess = new OTraverseMultiValueProcess((OTraverse)this.command, coll, this.getPath().appendField(field.toString()));
            } else {
                if (!(fieldValue instanceof OIdentifiable) || !(((OIdentifiable)fieldValue).getRecord() instanceof ODocument)) continue;
                subProcess = new OTraverseRecordProcess((OTraverse)this.command, (ODocument)((OIdentifiable)fieldValue).getRecord(), this.getPath().appendField(field.toString()));
            }
            ((OTraverse)this.command).getContext().push((OTraverseAbstractProcess<?>)var5_5);
        }
    }

    @Override
    public String toString() {
        return this.target != null ? ((ODocument)this.target).getIdentity().toString() : "-";
    }

    @Override
    public OTraversePath getPath() {
        return this.path;
    }
}

