/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.util.OService;

public abstract class OSoftThread
extends Thread
implements OService {
    private volatile boolean shutdownFlag;

    public OSoftThread() {
    }

    public OSoftThread(ThreadGroup iThreadGroup) {
        super(iThreadGroup, OSoftThread.class.getSimpleName());
        this.setDaemon(true);
    }

    public OSoftThread(String name) {
        super(name);
        this.setDaemon(true);
    }

    public OSoftThread(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
    }

    protected abstract void execute() throws Exception;

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }

    public void sendShutdown() {
        this.shutdownFlag = true;
    }

    public boolean isShutdownFlag() {
        return this.shutdownFlag;
    }

    @Override
    public void run() {
        this.startup();
        while (!this.shutdownFlag && !this.isInterrupted()) {
            try {
                this.beforeExecution();
                this.execute();
                this.afterExecution();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.shutdown();
    }

    public static boolean pauseCurrentThread(long iTime) {
        try {
            if (iTime <= 0L) {
                iTime = Long.MAX_VALUE;
            }
            Thread.sleep(iTime);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void beforeExecution() throws InterruptedException {
    }

    protected void afterExecution() throws InterruptedException {
    }
}

