/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.nio.ByteOrder;

public class OCharSerializer
implements OBinarySerializer<Character> {
    public static final int CHAR_SIZE = 2;
    public static final byte ID = 3;
    private static final OBinaryConverter BINARY_CONVERTER = OBinaryConverterFactory.getConverter();
    public static OCharSerializer INSTANCE = new OCharSerializer();

    @Override
    public int getObjectSize(Character object, Object ... hints) {
        return 2;
    }

    @Override
    public void serialize(Character object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object.charValue(), stream, startPosition);
    }

    public void serializeLiteral(char value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 8);
        stream[startPosition + 1] = (byte)value;
    }

    @Override
    public Character deserialize(byte[] stream, int startPosition) {
        return Character.valueOf(this.deserializeLiteral(stream, startPosition));
    }

    public char deserializeLiteral(byte[] stream, int startPosition) {
        return (char)(((stream[startPosition] & 0xFF) << 8) + (stream[startPosition + 1] & 0xFF));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNativeObject(Character object, byte[] stream, int startPosition, Object ... hints) {
        BINARY_CONVERTER.putChar(stream, startPosition, object.charValue(), ByteOrder.nativeOrder());
    }

    @Override
    public Character deserializeNativeObject(byte[] stream, int startPosition) {
        return Character.valueOf(BINARY_CONVERTER.getChar(stream, startPosition, ByteOrder.nativeOrder()));
    }

    public void serializeNative(char object, byte[] stream, int startPosition, Object ... hints) {
        BINARY_CONVERTER.putChar(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public char deserializeNative(byte[] stream, int startPosition) {
        return BINARY_CONVERTER.getChar(stream, startPosition, ByteOrder.nativeOrder());
    }

    public void serializeInDirectMemory(char object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setChar(offset, object);
    }

    public Character deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return Character.valueOf(pointer.getChar(offset));
    }

    @Override
    public void serializeInDirectMemoryObject(Character object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setChar(offset, object.charValue());
    }

    @Override
    public Character deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        return Character.valueOf(pointer.getChar(offset));
    }

    @Override
    public Character deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return Character.valueOf((char)wrapper.getShort(offset));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 2;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 2;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }

    @Override
    public Character preprocess(Character value, Object ... hints) {
        return value;
    }
}

