/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;

public class OBooleanSerializer
implements OBinarySerializer<Boolean> {
    public static final int BOOLEAN_SIZE = 1;
    public static final byte ID = 1;
    public static OBooleanSerializer INSTANCE = new OBooleanSerializer();

    @Override
    public int getObjectSize(Boolean object, Object ... hints) {
        return 1;
    }

    @Override
    public void serialize(Boolean object, byte[] stream, int startPosition, Object ... hints) {
        stream[startPosition] = object != false ? (byte)1 : 0;
    }

    public void serializeLiteral(boolean value, byte[] stream, int startPosition) {
        stream[startPosition] = value ? (byte)1 : 0;
    }

    @Override
    public Boolean deserialize(byte[] stream, int startPosition) {
        return stream[startPosition] == 1;
    }

    public boolean deserializeLiteral(byte[] stream, int startPosition) {
        return stream[startPosition] == 1;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public void serializeNativeObject(Boolean object, byte[] stream, int startPosition, Object ... hints) {
        this.serialize(object, stream, startPosition, new Object[0]);
    }

    public void serializeNative(boolean object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    @Override
    public Boolean deserializeNativeObject(byte[] stream, int startPosition) {
        return this.deserialize(stream, startPosition);
    }

    public boolean deserializeNative(byte[] stream, int startPosition) {
        return this.deserializeLiteral(stream, startPosition);
    }

    public void serializeInDirectMemory(Boolean object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object != false ? (byte)1 : 0);
    }

    @Override
    public void serializeInDirectMemoryObject(Boolean object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object != false ? (byte)1 : 0);
    }

    public void serializeInDirectMemory(boolean object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object ? (byte)1 : 0);
    }

    @Override
    public Boolean deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset) > 0;
    }

    @Override
    public Boolean deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getByte(offset) > 0;
    }

    public boolean deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset) > 0;
    }

    public boolean deserializeFromDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getByte(offset) > 0;
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 1;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 1;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }

    @Override
    public Boolean preprocess(Boolean value, Object ... hints) {
        return value;
    }
}

