/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public class OUnsafeBinaryConverter
implements OBinaryConverter {
    public static final OUnsafeBinaryConverter INSTANCE = new OUnsafeBinaryConverter();
    private static final Unsafe theUnsafe;
    private static final long BYTE_ARRAY_OFFSET;
    private static final boolean useOnlyAlignedAccess;

    @Override
    public void putShort(byte[] buffer, int index, short value, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                value = Short.reverseBytes(value);
            }
            theUnsafe.putShort(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
        } else if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)(value >>> 8));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)value);
        } else {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)value);
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)(value >>> 8));
        }
    }

    @Override
    public short getShort(byte[] buffer, int index, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            short result = theUnsafe.getShort(buffer, (long)index + BYTE_ARRAY_OFFSET);
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                result = Short.reverseBytes(result);
            }
            return result;
        }
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (short)(theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET) << 8 | theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L) & 0xFF);
        }
        return (short)(theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET) & 0xFF | theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L) << 8);
    }

    @Override
    public void putInt(byte[] buffer, int pointer, int value, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            long position = (long)pointer + BYTE_ARRAY_OFFSET;
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                value = Integer.reverseBytes(value);
            }
            theUnsafe.putInt(buffer, position, value);
        } else if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET, (byte)(value >>> 24));
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 1L, (byte)(value >>> 16));
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 2L, (byte)(value >>> 8));
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 3L, (byte)value);
        } else {
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET, (byte)value);
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 1L, (byte)(value >>> 8));
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 2L, (byte)(value >>> 16));
            theUnsafe.putByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 3L, (byte)(value >>> 24));
        }
    }

    @Override
    public int getInt(byte[] buffer, int pointer, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            long position = (long)pointer + BYTE_ARRAY_OFFSET;
            int result = theUnsafe.getInt(buffer, position);
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                result = Integer.reverseBytes(result);
            }
            return result;
        }
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET)) << 24 | (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 1L)) << 16 | (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 2L)) << 8 | 0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 3L);
        }
        return 0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET) | (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 1L)) << 8 | (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 2L)) << 16 | (0xFF & theUnsafe.getByte(buffer, (long)pointer + BYTE_ARRAY_OFFSET + 3L)) << 24;
    }

    @Override
    public void putLong(byte[] buffer, int index, long value, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                value = Long.reverseBytes(value);
            }
            theUnsafe.putLong(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
        } else if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)(value >>> 56));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)(value >>> 48));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 2L, (byte)(value >>> 40));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 3L, (byte)(value >>> 32));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 4L, (byte)(value >>> 24));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 5L, (byte)(value >>> 16));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 6L, (byte)(value >>> 8));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 7L, (byte)value);
        } else {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)value);
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)(value >>> 8));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 2L, (byte)(value >>> 16));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 3L, (byte)(value >>> 24));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 4L, (byte)(value >>> 32));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 5L, (byte)(value >>> 40));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 6L, (byte)(value >>> 48));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 7L, (byte)(value >>> 56));
        }
    }

    @Override
    public long getLong(byte[] buffer, int index, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            long result = theUnsafe.getLong(buffer, (long)index + BYTE_ARRAY_OFFSET);
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                result = Long.reverseBytes(result);
            }
            return result;
        }
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET)) << 56 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L)) << 48 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 2L)) << 40 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 3L)) << 32 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 4L)) << 24 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 5L)) << 16 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 6L)) << 8 | 0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 7L);
        }
        return 0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET) | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L)) << 8 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 2L)) << 16 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 3L)) << 24 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 4L)) << 32 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 5L)) << 40 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 6L)) << 48 | (0xFFL & (long)theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 7L)) << 56;
    }

    @Override
    public void putChar(byte[] buffer, int index, char character, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                character = Character.reverseBytes(character);
            }
            theUnsafe.putChar(buffer, (long)index + BYTE_ARRAY_OFFSET, character);
        } else if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)(character >>> 8));
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)character);
        } else {
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET, (byte)character);
            theUnsafe.putByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L, (byte)(character >>> 8));
        }
    }

    @Override
    public char getChar(byte[] buffer, int index, ByteOrder byteOrder) {
        if (!useOnlyAlignedAccess) {
            char result = theUnsafe.getChar(buffer, (long)index + BYTE_ARRAY_OFFSET);
            if (!byteOrder.equals(ByteOrder.nativeOrder())) {
                result = Character.reverseBytes(result);
            }
            return result;
        }
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (char)(theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET) << 8 | theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L) & 0xFF);
        }
        return (char)(theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET) & 0xFF | theUnsafe.getByte(buffer, (long)index + BYTE_ARRAY_OFFSET + 1L) << 8);
    }

    @Override
    public boolean nativeAccelerationUsed() {
        return true;
    }

    static {
        useOnlyAlignedAccess = OGlobalConfiguration.DIRECT_MEMORY_ONLY_ALIGNED_ACCESS.getValueAsBoolean();
        theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                boolean wasAccessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    Object object = f.get(null);
                    f.setAccessible(wasAccessible);
                    return object;
                }
                catch (Throwable throwable) {
                    try {
                        f.setAccessible(wasAccessible);
                        throw throwable;
                    }
                    catch (NoSuchFieldException e) {
                        throw new Error();
                    }
                    catch (IllegalAccessException e) {
                        throw new Error();
                    }
                }
            }
        });
        BYTE_ARRAY_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
    }
}

