/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class OAbstractProfiler
extends OSharedResourceAbstract
implements OProfilerMBean,
OOrientStartupListener {
    protected final Map<String, OProfilerHookValue> hooks = new ConcurrentHashMap<String, OProfilerHookValue>();
    protected final ConcurrentHashMap<String, String> dictionary = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, OProfilerMBean.METRIC_TYPE> types = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, AtomicInteger> tips = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Long> tipsTimestamp = new ConcurrentHashMap();
    protected long recordingFrom = -1L;

    public OAbstractProfiler() {
        Orient.instance().registerWeakOrientStartupListener(this);
    }

    public OAbstractProfiler(OAbstractProfiler profiler) {
        this.hooks.putAll(profiler.hooks);
        this.dictionary.putAll(profiler.dictionary);
        this.types.putAll(profiler.types);
        Orient.instance().registerWeakOrientStartupListener(this);
    }

    public static void dumpEnvironment(PrintStream out) {
        Runtime runtime = Runtime.getRuntime();
        int stgs = 0;
        long diskCacheUsed = 0L;
        long diskCacheTotal = 0L;
        for (OStorage stg : Orient.instance().getStorages()) {
            if (!(stg instanceof OLocalPaginatedStorage)) continue;
            diskCacheUsed += ((OLocalPaginatedStorage)stg).getDiskCache().getUsedMemory();
            diskCacheTotal += OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
            ++stgs;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName osMBeanName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            if (mbs.isInstanceOf(osMBeanName, "com.sun.management.OperatingSystemMXBean")) {
                long osTotalMem = ((Number)mbs.getAttribute(osMBeanName, "TotalPhysicalMemorySize")).longValue();
                long osUsedMem = ((Number)mbs.getAttribute(osMBeanName, "FreePhysicalMemorySize")).longValue();
                out.printf("OrientDB Memory profiler: Heap=%s of %s - DiskCache (%s dbs)=%s of %s - OS=%s of %s\n", OFileUtils.getSizeAsString(runtime.totalMemory() - runtime.freeMemory()), OFileUtils.getSizeAsString(runtime.maxMemory()), stgs, OFileUtils.getSizeAsString(diskCacheUsed), OFileUtils.getSizeAsString(diskCacheTotal), OFileUtils.getSizeAsString(osUsedMem), OFileUtils.getSizeAsString(osTotalMem));
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        out.printf("OrientDB Memory profiler: Heap=%s of %s - DiskCache (%s dbs)=%s of %s\n", OFileUtils.getSizeAsString(runtime.totalMemory() - runtime.freeMemory()), OFileUtils.getSizeAsString(runtime.maxMemory()), stgs, OFileUtils.getSizeAsString(diskCacheUsed), OFileUtils.getSizeAsString(diskCacheTotal));
    }

    @Override
    public void onStartup() {
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
            this.startRecording();
        }
        this.installMemoryChecker();
    }

    @Override
    public void shutdown() {
        this.stopRecording();
    }

    @Override
    public int reportTip(String iMessage) {
        AtomicInteger counter = this.tips.get(iMessage);
        if (counter == null) {
            OLogManager.instance().info((Object)this, "[TIP] " + iMessage, new Object[0]);
            this.tips.put(iMessage, new AtomicInteger(1));
            this.tipsTimestamp.put(iMessage, System.currentTimeMillis());
            return 1;
        }
        this.tipsTimestamp.put(iMessage, System.currentTimeMillis());
        return counter.incrementAndGet();
    }

    @Override
    public boolean startRecording() {
        if (this.isRecording()) {
            return false;
        }
        this.recordingFrom = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean stopRecording() {
        if (!this.isRecording()) {
            return false;
        }
        this.recordingFrom = -1L;
        return true;
    }

    @Override
    public boolean isRecording() {
        return this.recordingFrom > -1L;
    }

    @Override
    public void updateCounter(String iStatName, String iDescription, long iPlus) {
        this.updateCounter(iStatName, iDescription, iPlus, iStatName);
    }

    @Override
    public String getName() {
        return "profiler";
    }

    @Override
    public void startup() {
        this.startRecording();
    }

    @Override
    public String dump() {
        return null;
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        return null;
    }

    @Override
    public String[] getChronosAsString() {
        return null;
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public void setAutoDump(int iNewValue) {
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public Map<String, OPair<String, OProfilerMBean.METRIC_TYPE>> getMetadata() {
        HashMap<String, OPair<String, OProfilerMBean.METRIC_TYPE>> metadata = new HashMap<String, OPair<String, OProfilerMBean.METRIC_TYPE>>();
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            metadata.put(entry.getKey(), new OPair<Comparable, OProfilerMBean.METRIC_TYPE>((Comparable)((Object)entry.getValue()), this.types.get(entry.getKey())));
        }
        return metadata;
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType, OProfilerHookValue iHookValue) {
        this.registerHookValue(iName, iDescription, iType, iHookValue, iName);
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType, OProfilerHookValue iHookValue, String iMetadataName) {
        if (iName != null) {
            this.unregisterHookValue(iName);
            this.updateMetadata(iMetadataName, iDescription, iType);
            this.hooks.put(iName, iHookValue);
        }
    }

    @Override
    public void unregisterHookValue(String iName) {
        if (iName != null) {
            this.hooks.remove(iName);
        }
    }

    @Override
    public String getSystemMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder("system.".length() + iMetricName.length() + 1);
        buffer.append("system.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getProcessMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder("process.".length() + iMetricName.length() + 1);
        buffer.append("process.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getDatabaseMetric(String iDatabaseName, String iMetricName) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("db.");
        buffer.append(iDatabaseName != null ? iDatabaseName : "*");
        buffer.append('.');
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    public String dumpTips() {
        if (this.recordingFrom < 0L) {
            return "Tips: <no recording>";
        }
        StringBuilder buffer = new StringBuilder();
        if (this.tips.size() == 0) {
            return "";
        }
        buffer.append("TIPS:");
        buffer.append(String.format("\n%100s +------------+", ""));
        buffer.append(String.format("\n%100s | Value      |", "Name"));
        buffer.append(String.format("\n%100s +------------+", ""));
        ArrayList names = new ArrayList(this.tips.keySet());
        Collections.sort(names);
        for (String n : names) {
            AtomicInteger v = this.tips.get(n);
            buffer.append(String.format("\n%-100s | %10d |", n, v));
        }
        buffer.append(String.format("\n%100s +------------+", ""));
        return buffer.toString();
    }

    protected void installMemoryChecker() {
        Orient.instance().scheduleTask((TimerTask)new MemoryChecker(), 120000L, 120000L);
    }

    protected void updateMetadata(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }

    private static final class MemoryChecker
    extends TimerTask {
        private MemoryChecker() {
        }

        @Override
        public void run() {
            long jvmTotMemory = Runtime.getRuntime().totalMemory();
            long jvmMaxMemory = Runtime.getRuntime().maxMemory();
            for (OStorage s : Orient.instance().getStorages()) {
                ODiskCache dk;
                if (!(s instanceof OLocalPaginatedStorage) || (dk = ((OLocalPaginatedStorage)s).getDiskCache()) == null) continue;
                long totalDiskCacheUsedMemory = dk.getUsedMemory() / 0x100000L;
                long maxDiskCacheUsedMemory = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong();
                if (jvmTotMemory * 140L / 100L >= jvmMaxMemory || totalDiskCacheUsedMemory * 120L / 100L <= maxDiskCacheUsedMemory) continue;
                long suggestedMaxHeap = jvmTotMemory * 120L / 100L;
                long suggestedDiskCache = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() + (jvmMaxMemory - suggestedMaxHeap) / 0x100000L;
                OLogManager.instance().info((Object)this, "Database '%s' uses %,dMB/%,dMB of DISKCACHE memory, while Heap is not completely used (usedHeap=%dMB maxHeap=%dMB). To improve performance set maxHeap to %dMB and DISKCACHE to %dMB", s.getName(), totalDiskCacheUsedMemory, maxDiskCacheUsedMemory, jvmTotMemory / 0x100000L, jvmMaxMemory / 0x100000L, suggestedMaxHeap / 0x100000L, suggestedDiskCache);
                OLogManager.instance().info((Object)this, "-> Open server.sh (or server.bat on Windows) and change the following variables: 1) MAXHEAP=-Xmx%dM 2) MAXDISKCACHE=%d", suggestedMaxHeap / 0x100000L, suggestedDiskCache);
            }
        }
    }

    public static interface OProfilerHookValue {
        public Object getValue();
    }
}

