/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OLogFormatter
extends Formatter {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String EOL = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() == null) {
            return this.customFormatMessage(record);
        }
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(record.getMessage());
        Throwable current = record.getThrown();
        if (current != null) {
            buffer.append(EOL);
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            current.printStackTrace(printWriter);
            printWriter.flush();
            buffer.append(writer.getBuffer());
            printWriter.close();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String customFormatMessage(LogRecord iRecord) {
        Level iLevel = iRecord.getLevel();
        String iMessage = iRecord.getMessage();
        Object[] iAdditionalArgs = iRecord.getParameters();
        String iRequester = this.getSourceClassSimpleName(iRecord.getLoggerName());
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(EOL);
        DateFormat dateFormat = OLogFormatter.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OLogFormatter.dateFormat.format(new Date()));
        }
        buffer.append(String.format(" %-5s ", iLevel.getName()));
        try {
            if (iAdditionalArgs != null) {
                buffer.append(String.format(iMessage, iAdditionalArgs));
            } else {
                buffer.append(iMessage);
            }
        }
        catch (Exception e) {
            buffer.append(iMessage);
        }
        if (iRequester != null) {
            buffer.append(" [");
            buffer.append(iRequester);
            buffer.append(']');
        }
        return buffer.toString();
    }

    private String getSourceClassSimpleName(String iSourceClassName) {
        return iSourceClassName.substring(iSourceClassName.lastIndexOf(".") + 1);
    }
}

