/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.io;

import com.orientechnologies.common.io.OFileUtilsJava7;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;

public class OFileUtils {
    public static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int GIGABYTE = 0x40000000;
    public static final long TERABYTE = 0x10000000000L;
    private static final boolean useOldFileAPI;

    public static long getSizeAsNumber(Object iSize) {
        if (iSize == null) {
            throw new IllegalArgumentException("Size is null");
        }
        if (iSize instanceof Number) {
            return ((Number)iSize).longValue();
        }
        String size = iSize.toString();
        boolean number = true;
        for (int i = size.length() - 1; i >= 0; --i) {
            if (Character.isDigit(size.charAt(i))) continue;
            number = false;
            break;
        }
        if (number) {
            return OFileUtils.string2number(size).longValue();
        }
        int pos = (size = size.toUpperCase(Locale.ENGLISH)).indexOf("KB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1024.0f);
        }
        pos = size.indexOf("MB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1048576.0f);
        }
        pos = size.indexOf("GB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1.0737418E9f);
        }
        pos = size.indexOf("TB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1.0995116E12f);
        }
        pos = size.indexOf(66);
        if (pos > -1) {
            return (long)OFileUtils.string2number(size.substring(0, pos)).floatValue();
        }
        pos = size.indexOf(37);
        if (pos > -1) {
            return (long)(-1.0f * OFileUtils.string2number(size.substring(0, pos)).floatValue());
        }
        throw new IllegalArgumentException("Size " + size + " has a unrecognizable format");
    }

    public static Number string2number(String iText) {
        if (iText.indexOf(46) > -1) {
            return Double.parseDouble(iText);
        }
        return Long.parseLong(iText);
    }

    public static String getSizeAsString(long iSize) {
        if (iSize > 0x10000000000L) {
            return String.format("%2.2fTB", Float.valueOf((float)iSize / 1.0995116E12f));
        }
        if (iSize > 0x40000000L) {
            return String.format("%2.2fGB", Float.valueOf((float)iSize / 1.0737418E9f));
        }
        if (iSize > 0x100000L) {
            return String.format("%2.2fMB", Float.valueOf((float)iSize / 1048576.0f));
        }
        if (iSize > 1024L) {
            return String.format("%2.2fKB", Float.valueOf((float)iSize / 1024.0f));
        }
        return String.valueOf(iSize) + "b";
    }

    public static String getDirectory(String iPath) {
        int pos = (iPath = OFileUtils.getPath(iPath)).lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        return iPath.substring(0, pos);
    }

    public static void createDirectoryTree(String iFileName) {
        String[] fileDirectories = iFileName.split("/");
        for (int i = 0; i < fileDirectories.length - 1; ++i) {
            new File(fileDirectories[i]).mkdir();
        }
    }

    public static String getPath(String iPath) {
        if (iPath == null) {
            return null;
        }
        return iPath.replace('\\', '/');
    }

    public static void checkValidName(String iFileName) throws IOException {
        if (iFileName.contains("..") || iFileName.contains("/") || iFileName.contains("\\")) {
            throw new IOException("Invalid file name '" + iFileName + "'");
        }
    }

    public static void deleteRecursively(File iRootFile) {
        if (iRootFile.exists()) {
            if (iRootFile.isDirectory()) {
                for (File f : iRootFile.listFiles()) {
                    if (f.isFile()) {
                        f.delete();
                        continue;
                    }
                    OFileUtils.deleteRecursively(f);
                }
            }
            iRootFile.delete();
        }
    }

    public static final void copyFile(File source, File destination) throws IOException {
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(destination).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
    }

    public static final void copyDirectory(File source, File destination) throws IOException {
        if (!destination.exists()) {
            destination.mkdirs();
        }
        for (File f : source.listFiles()) {
            File target = new File(destination.getAbsolutePath() + "/" + f.getName());
            if (f.isFile()) {
                OFileUtils.copyFile(f, target);
                continue;
            }
            OFileUtils.copyDirectory(f, target);
        }
    }

    public static boolean renameFile(File from, File to) throws IOException {
        if (useOldFileAPI) {
            return from.renameTo(to);
        }
        FileSystem fileSystem = FileSystems.getDefault();
        Path fromPath = fileSystem.getPath(from.getAbsolutePath(), new String[0]);
        Path toPath = fileSystem.getPath(to.getAbsolutePath(), new String[0]);
        Files.move(fromPath, toPath, new CopyOption[0]);
        return true;
    }

    public static boolean delete(File file) throws IOException {
        if (!file.exists()) {
            return true;
        }
        if (useOldFileAPI) {
            return file.delete();
        }
        return OFileUtilsJava7.delete(file);
    }

    static {
        boolean oldAPI = false;
        try {
            Class.forName("java.nio.file.FileSystemException");
        }
        catch (ClassNotFoundException e) {
            oldAPI = true;
        }
        useOldFileAPI = oldAPI;
    }
}

