/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;

public class ScanSummary
implements Serializable {
    private static final long serialVersionUID = -3592927252689743774L;
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private String scannerDriver;
    private String scannerVersion;
    private String operatingSystem;
    private String processorArchitecture;
    private String hostName;
    private Set<String> ipAddresses;
    private String startTime;
    private String endTime;
    private Integer directories;
    private Integer archives;
    private Integer symlinks;
    private Integer files;
    private Integer classFiles;
    private Integer inaccessibleFiles;
    private Integer snapshots;
    private Integer errorCount;
    private Properties clientInfo;

    public String getScannerDriver() {
        return this.scannerDriver;
    }

    public void setScannerDriver(String scannerDriver) {
        this.scannerDriver = scannerDriver;
    }

    public String getScannerVersion() {
        return this.scannerVersion;
    }

    public void setScannerVersion(String scannerVersion) {
        this.scannerVersion = scannerVersion;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setStartTime() {
        this.setStartTime(this.getDateFormat().format(new Date()));
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setEndTime() {
        this.setEndTime(this.getDateFormat().format(new Date()));
    }

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getProcessorArchitecture() {
        return this.processorArchitecture;
    }

    public void setProcessorArchitecture(String processorArchitecture) {
        this.processorArchitecture = processorArchitecture;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Set<String> getIpAddresses() {
        if (this.ipAddresses == null) {
            this.ipAddresses = new HashSet<String>();
        }
        return this.ipAddresses;
    }

    public void addIpAddress(String ipAddress) {
        this.getIpAddresses().add(ipAddress);
    }

    public int getDirectories() {
        return this.fromInteger(this.directories);
    }

    public void setDirectories(int directories) {
        this.directories = this.toInteger(directories);
    }

    public int getArchives() {
        return this.fromInteger(this.archives);
    }

    public void setArchives(int archives) {
        this.archives = this.toInteger(archives);
    }

    public int getSymLinks() {
        return this.fromInteger(this.symlinks);
    }

    public void setSymlinks(int symLinks) {
        this.symlinks = this.toInteger(symLinks);
    }

    public int getFiles() {
        return this.fromInteger(this.files);
    }

    public void setFiles(int files) {
        this.files = this.toInteger(files);
    }

    public int getClassFiles() {
        return this.fromInteger(this.classFiles);
    }

    public void setClassFiles(int classFiles) {
        this.classFiles = this.toInteger(classFiles);
    }

    public int getInaccessibleFiles() {
        return this.fromInteger(this.inaccessibleFiles);
    }

    public void setInaccessibleFiles(int inaccessibleFiles) {
        this.inaccessibleFiles = this.toInteger(inaccessibleFiles);
    }

    public int getSnapshots() {
        return this.fromInteger(this.snapshots);
    }

    public void setSnapshots(int snapshots) {
        this.snapshots = this.toInteger(snapshots);
    }

    public int getErrorCount() {
        return this.fromInteger(this.errorCount);
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = this.toInteger(errorCount);
    }

    private int fromInteger(Integer num) {
        return num != null ? num : 0;
    }

    private Integer toInteger(int value) {
        return value != 0 ? Integer.valueOf(value) : null;
    }

    public Properties getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(Properties clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void putClientInfo(Properties clientInfo) {
        if (clientInfo != null && !clientInfo.isEmpty()) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.putAll((Map<?, ?>)clientInfo);
        }
    }

    public void putClientInfo(String key, String value) {
        if (value != null) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.setProperty(key, value);
        } else if (this.clientInfo != null) {
            this.clientInfo.remove(key);
        }
    }
}

