/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanItemContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DependencyScanItem
extends ScanItem
implements ScanItemContainer {
    private static final long serialVersionUID = -8182668828110117223L;
    private String scopes;
    private List<DependencyScanItem> dependencies;

    public static DependencyScanItem maven(String groupId, String artifactId, String extension, String classifier, String version, String scopes) {
        ArtifactId id = ArtifactId.maven(groupId, artifactId, extension, classifier, version);
        return new DependencyScanItem(id.getKind(), id.getId(), scopes);
    }

    public DependencyScanItem() {
    }

    public DependencyScanItem(String kind, String id, String scopes) {
        this.setKind(kind);
        this.setId(id);
        this.setScopes(scopes);
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public List<DependencyScanItem> getDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dependencies);
    }

    public void addDependency(DependencyScanItem dependency) {
        if (dependency != null) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<DependencyScanItem>();
            }
            this.dependencies.add(dependency);
        }
    }

    @Override
    public List<? extends ScanItem> getItems() {
        return this.getDependencies();
    }

    @Override
    public void addItem(ScanItem item) {
        if (item != null && !(item instanceof DependencyScanItem)) {
            throw new IllegalArgumentException("invalid child " + item);
        }
        this.addDependency((DependencyScanItem)item);
    }

    @Override
    public String toString() {
        return this.getKind() + ":" + this.getId() + " (" + this.getScopes() + ")";
    }
}

