/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import java.io.Serializable;

public class ArtifactId
implements Serializable {
    private static final long serialVersionUID = 8020935824181583347L;
    public static final char SEPARATOR = ':';
    public static final String KIND_MAVEN = "maven";
    public static final String KIND_IVY = "ivy";
    public static final String KIND_OSGI = "osgi";
    public static final String KIND_NUGET = "nuget";
    private String kind;
    private String id;

    public ArtifactId() {
    }

    public ArtifactId(String kind, String id) {
        this.setKind(kind);
        this.setId(id);
    }

    public static String[] split(String id) {
        if (id == null) {
            return null;
        }
        return id.split("\\:", -1);
    }

    public static ArtifactId maven(String groupId, String artifactId, String version) {
        String id = ArtifactId.emptify(groupId) + ':' + ArtifactId.emptify(artifactId) + ':' + ArtifactId.emptify(version);
        return new ArtifactId(KIND_MAVEN, id);
    }

    public static ArtifactId maven(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(ArtifactId.emptify(groupId));
        buffer.append(':').append(ArtifactId.emptify(artifactId));
        buffer.append(':').append(ArtifactId.emptify(extension));
        if (classifier != null && classifier.length() > 0) {
            buffer.append(':').append(classifier);
        }
        buffer.append(':').append(version);
        return new ArtifactId(KIND_MAVEN, buffer.toString());
    }

    public static ArtifactId osgi(String bundleId, String version) {
        String id = ArtifactId.emptify(bundleId) + ':' + ArtifactId.emptify(version);
        return new ArtifactId(KIND_OSGI, id);
    }

    public static ArtifactId nuget(String packageId, String version) {
        String id = ArtifactId.emptify(packageId) + ':' + ArtifactId.emptify(version);
        return new ArtifactId(KIND_NUGET, id);
    }

    private static String emptify(String str) {
        return str != null ? str : "";
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        if (this.id == null) {
            return null;
        }
        int colon = this.id.lastIndexOf(58);
        if (colon < 0) {
            return null;
        }
        return this.id.substring(colon + 1);
    }

    public String toString() {
        return this.getKind() + ':' + this.getId();
    }
}

