/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.bcprov.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.security.Provider;
import java.security.Security;
import javax.inject.Inject;
import javax.inject.Named;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@EagerSingleton
public class BCPluginEventHandler
extends ComponentSupport {
    private final boolean registered;

    @Inject
    public BCPluginEventHandler(EventBus eventBus) {
        Preconditions.checkNotNull((Object)eventBus);
        boolean bl = this.registered = Security.addProvider((Provider)new BouncyCastleProvider()) != -1;
        if (this.registered) {
            this.log.debug("BouncyCastle security provider registered");
        } else {
            this.log.warn("BouncyCastle security provider already registered; could become problematic");
        }
        eventBus.register((Object)this);
    }

    @Subscribe
    public void onNexusStoppedEvent(NexusStoppedEvent e) {
        if (this.registered) {
            Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
            this.log.debug("BouncyCastle security provider unregistered");
        }
    }
}

