/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ScanReader;
import com.sonatype.insight.scan.model.io.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
public class DefaultScanReader
implements ScanReader {
    private final Logger log;
    private final XStream xstream;

    @Inject
    public DefaultScanReader(Logger log) {
        this.log = log;
        this.xstream = this.newXStream();
    }

    private XStream newXStream() {
        XStream xstream = XStreamFactory.newInstance();
        xstream.aliasField("jreInfo", ScanSummary.class, "clientInfo");
        return xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scan read(File file) throws IOException {
        this.log.info("Reading scan data from {}", (Object)file);
        GZIPInputStream fis = new GZIPInputStream(new FileInputStream(file));
        try {
            Scan scan = this.read(fis);
            return scan;
        }
        finally {
            ((InputStream)fis).close();
        }
    }

    @Override
    public Scan read(InputStream in) throws IOException {
        try {
            Object root = this.xstream.fromXML(in);
            if (!(root instanceof Scan)) {
                throw new IOException("Corrupted scan file, got unexpected root element " + root.getClass().getName());
            }
            return (Scan)root;
        }
        catch (XStreamException e) {
            throw new IOException("Unsupported scan file format", e);
        }
    }
}

