/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.Application;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ReverseLookupTableReader;
import com.sonatype.insight.scan.model.io.ReverseLookupTableWriter;
import com.sonatype.insight.scan.model.io.ScanAggregator;
import com.sonatype.insight.scan.model.io.ScanReader;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
public class DefaultScanAggregator
implements ScanAggregator {
    private final Logger log;
    private final ScanReader scanReader;
    private final ScanWriterFactory scanWriterFactory;
    private final ReverseLookupTableReader tableReader;
    private final ReverseLookupTableWriter tableWriter;

    @Inject
    public DefaultScanAggregator(Logger log, ScanReader scanReader, ScanWriterFactory scanWriterFactory, ReverseLookupTableReader tableReader, ReverseLookupTableWriter tableWriter) {
        this.log = log;
        this.scanReader = scanReader;
        this.scanWriterFactory = scanWriterFactory;
        this.tableReader = tableReader;
        this.tableWriter = tableWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scan aggregateScans(File outputFile, Collection<File> inputFiles) throws IOException {
        if (inputFiles == null || inputFiles.isEmpty()) {
            throw new IllegalArgumentException("No input scan files specified to aggregate");
        }
        this.log.info("Aggregating scan data into {}", (Object)outputFile);
        Scan tmp = null;
        for (File file : inputFiles) {
            if (tmp == null) {
                tmp = this.scanReader.read(file);
                continue;
            }
            Scan source = this.scanReader.read(file);
            this.merge(tmp.getApplication(), source.getApplication());
            this.merge(tmp.getRepository(), source.getRepository());
            this.merge(tmp.getSummary(), source.getSummary());
            this.merge(tmp.getConfiguration(), source.getConfiguration());
        }
        ScanWriter writer = null;
        try {
            writer = this.scanWriterFactory.newWriter(outputFile);
            writer.openScan(tmp);
            writer.writeApplication(tmp.getApplication());
            writer.writeRepository(tmp.getRepository());
            writer.writeSummary(tmp.getSummary());
            writer.writeConfiguration(tmp.getConfiguration());
            for (File file : inputFiles) {
                Scan source = this.scanReader.read(file);
                for (ScanItem item : source.getItems()) {
                    writer.writeScanItem(item);
                }
            }
            writer.closeScan();
            Scan scan = tmp;
            return scan;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void merge(Application target, Application source) throws IOException {
        if (target == null && source == null) {
            return;
        }
        if (target == null || source == null) {
            throw new IOException("Cannot aggregate scans from different sources");
        }
        if (target.getId() == null && source.getId() != null || target.getId() != null && !target.getId().equalsIgnoreCase(source.getId())) {
            throw new IOException("Cannot aggregate scans from different applications: " + target.getId() + " vs " + source.getId());
        }
    }

    private void merge(Repository target, Repository source) throws IOException {
        if (target == null && source == null) {
            return;
        }
        if (target == null || source == null) {
            throw new IOException("Cannot aggregate scans from different sources");
        }
        if (target.getId() == null && source.getId() != null || target.getId() != null && !target.getId().equals(source.getId())) {
            throw new IOException("Cannot aggregate scans from different repositories: " + target.getId() + " vs " + source.getId());
        }
        if (target.getManager() == null && source.getManager() != null || target.getManager() != null && !target.getManager().equals(source.getManager())) {
            throw new IOException("Cannot aggregate scans from different repository managers: " + target.getManager() + " vs " + source.getManager());
        }
    }

    private void merge(ScanSummary target, ScanSummary source) {
        target.putClientInfo(source.getClientInfo());
        target.setArchives(target.getArchives() + source.getArchives());
        target.setDirectories(target.getDirectories() + source.getDirectories());
        target.setFiles(target.getFiles() + source.getFiles());
        target.setClassFiles(target.getClassFiles() + source.getClassFiles());
        target.setSnapshots(target.getSnapshots() + source.getSnapshots());
        target.setInaccessibleFiles(target.getInaccessibleFiles() + source.getInaccessibleFiles());
        target.setSymlinks(target.getSymLinks() + source.getSymLinks());
        target.setErrorCount(target.getErrorCount() + source.getErrorCount());
        if (target.getStartTime().compareToIgnoreCase(source.getStartTime()) > 0) {
            target.setStartTime(source.getStartTime());
        }
        if (target.getEndTime().compareToIgnoreCase(source.getEndTime()) < 0) {
            target.setEndTime(source.getEndTime());
        }
    }

    private void merge(ScanConfiguration target, ScanConfiguration source) throws IOException {
        Properties props = target.getProperties();
        for (Map.Entry<Object, Object> entry : source.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            String cur = props.getProperty(key);
            if (cur == null) {
                props.setProperty(key, val);
                continue;
            }
            if (cur.equals(val)) continue;
            throw new IOException("Configuration divergence for option " + key + ": " + cur + " vs " + val);
        }
    }

    @Override
    public ReverseLookupTable aggregateReverseLookupTables(File outputFile, Collection<File> inputFiles) throws IOException {
        if (inputFiles == null || inputFiles.isEmpty()) {
            throw new IllegalArgumentException("No input table files specified to aggregate");
        }
        this.log.info("Aggregating reverse lookup tables into {}", (Object)outputFile);
        Iterator<File> it = inputFiles.iterator();
        ReverseLookupTable table = this.tableReader.read(it.next());
        while (it.hasNext()) {
            ReverseLookupTable tmp = this.tableReader.read(it.next());
            this.merge(table, tmp);
        }
        this.tableWriter.write(outputFile, table);
        return table;
    }

    private void merge(ReverseLookupTable target, ReverseLookupTable source) {
        for (File file : source.getFiles()) {
            target.addFile(file);
        }
        for (String anon : source.getAnonymizations()) {
            String value = source.lookupAnonymization(anon);
            target.addAnonymization(anon, value);
        }
        for (String fileHash : source.getFileHashes()) {
            String[] paths;
            for (String path : paths = source.lookupFileHashes(fileHash)) {
                target.addFileHash(fileHash, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregateLogs(File outputFile, Collection<File> inputFiles) throws IOException {
        if (inputFiles == null || inputFiles.isEmpty()) {
            throw new IllegalArgumentException("No input log files specified to aggregate");
        }
        outputFile.getAbsoluteFile().getParentFile().mkdirs();
        String encoding = "ISO-8859-1";
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));
        try {
            for (File inputFile : inputFiles) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        writer.write(line);
                        writer.newLine();
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        finally {
            writer.close();
        }
    }
}

