/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.io.ReverseLookupTableWriter;
import com.sonatype.insight.scan.model.io.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
public class DefaultReverseLookupTableWriter
implements ReverseLookupTableWriter {
    private final Logger log;

    @Inject
    public DefaultReverseLookupTableWriter(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, ReverseLookupTable table) throws IOException {
        this.log.info("Writing reverse lookup table to {}", (Object)file);
        file.getAbsoluteFile().getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.write(fos, table);
        }
        finally {
            fos.close();
        }
    }

    @Override
    public void write(OutputStream out, ReverseLookupTable table) throws IOException {
        XStream xstream = XStreamFactory.newInstance();
        xstream.toXML((Object)table, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }
}

