/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.io.ReverseLookupTableReader;
import com.sonatype.insight.scan.model.io.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
public class DefaultReverseLookupTableReader
implements ReverseLookupTableReader {
    private final Logger log;

    @Inject
    public DefaultReverseLookupTableReader(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReverseLookupTable read(File file) throws IOException {
        this.log.info("Reading reverse lookup table data from {}", (Object)file);
        FileInputStream fis = new FileInputStream(file);
        try {
            ReverseLookupTable reverseLookupTable = this.read(fis);
            return reverseLookupTable;
        }
        finally {
            ((InputStream)fis).close();
        }
    }

    @Override
    public ReverseLookupTable read(InputStream in) throws IOException {
        XStream xstream = XStreamFactory.newInstance();
        xstream.setClassLoader(DefaultReverseLookupTableReader.class.getClassLoader());
        Object root = xstream.fromXML(in);
        if (!(root instanceof ReverseLookupTable)) {
            throw new IOException("Corrupted scan file, got unexpected root element " + root.getClass().getName());
        }
        return (ReverseLookupTable)root;
    }
}

