/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.NugetUtils;
import com.sonatype.nexus.plugins.nuget.odata.NuspecSplicer;
import com.sonatype.nexus.plugins.nuget.proxy.NugetHostedRepository;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="RebuildNugetFeedTask")
public final class RebuildNugetFeedTask
extends AbstractNexusRepositoriesTask<Object> {
    private final Walker walker;
    private final NugetGallery gallery;

    @Inject
    public RebuildNugetFeedTask(Walker walker, NugetGallery gallery) {
        this.walker = (Walker)Preconditions.checkNotNull((Object)walker);
        this.gallery = (NugetGallery)Preconditions.checkNotNull((Object)gallery);
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected Object doRun() throws Exception {
        String repoId = this.getRepositoryId();
        if (null != repoId) {
            this.rebuildPackageFeed((NugetHostedRepository)this.getRepositoryRegistry().getRepositoryWithFacet(repoId, NugetHostedRepository.class));
        } else {
            this.rebuildPackageFeed(this.getRepositoryRegistry().getRepositoriesWithFacet(NugetHostedRepository.class));
        }
        return null;
    }

    protected String getAction() {
        return "Rebuilding NuGet feed";
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Rebuilding NuGet feed for repository " + this.getRepositoryName();
        }
        return "Rebuilding NuGet feeds for all hosted NuGet repositories";
    }

    private void rebuildPackageFeed(List<NugetHostedRepository> hosts) throws Exception {
        for (NugetHostedRepository h : hosts) {
            this.rebuildPackageFeed(h);
        }
    }

    private void rebuildPackageFeed(NugetHostedRepository host) throws Exception {
        final String hostId = host.getId();
        AbstractFileWalkerProcessor nugetProcessor = new AbstractFileWalkerProcessor(){

            protected void processFileItem(WalkerContext context, StorageFileItem item) throws Exception {
                RebuildNugetFeedTask.this.gallery.put(hostId, NuspecSplicer.consumeItem(item));
            }
        };
        ResourceStoreRequest request = new ResourceStoreRequest("/");
        DefaultWalkerContext ctx = new DefaultWalkerContext((Repository)host, request, (WalkerFilter)new NugetWalkerFilter());
        ctx.getProcessors().add(nugetProcessor);
        this.gallery.drop(hostId);
        this.walker.walk((WalkerContext)ctx);
    }

    static final class NugetWalkerFilter
    implements WalkerFilter {
        NugetWalkerFilter() {
        }

        public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
            return !coll.getName().startsWith(".");
        }

        public boolean shouldProcess(WalkerContext context, StorageItem item) {
            return NugetUtils.isNupkg(item);
        }
    }
}

