/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.feed.NugetFeedFetcher;
import com.sonatype.nexus.plugins.nuget.odata.ODataConsumer;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import com.sonatype.nexus.plugins.nuget.proxy.NugetProxyRepository;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.util.SystemPropertiesHelper;

@Named(value="DownloadNugetFeedTask")
public final class DownloadNugetFeedTask
extends AbstractNexusRepositoriesTask<Object> {
    private static final boolean ENABLED = SystemPropertiesHelper.getBoolean((String)"com.sonatype.nexus.plugins.nuget.tasks.DownloadNugetFeedTask.enabled", (boolean)false);
    private final NugetGallery gallery;
    private final NexusScheduler scheduler;
    private final NugetFeedFetcher fetcher;
    private boolean allVersions;
    private boolean clearCache;
    private boolean hasOldVersions;
    private boolean getOldVersions;
    private int retries;

    @Inject
    public DownloadNugetFeedTask(@Named(value="odata") NugetGallery gallery, NexusScheduler scheduler, NugetFeedFetcher fetcher) {
        this.gallery = (NugetGallery)Preconditions.checkNotNull((Object)gallery);
        this.scheduler = (NexusScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.fetcher = (NugetFeedFetcher)Preconditions.checkNotNull((Object)fetcher);
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected Object doRun() throws Exception {
        this.allVersions = Boolean.parseBoolean(this.getParameter("allVersions"));
        this.clearCache = Boolean.parseBoolean(this.getParameter("clearCache"));
        String retriesParameter = this.getParameter("retries");
        this.retries = 3;
        if (retriesParameter != null) {
            try {
                this.retries = Integer.parseInt(retriesParameter);
            }
            catch (NumberFormatException e) {
                this.retries = 3;
            }
        }
        this.retries = Math.max(this.retries, 1);
        this.getOldVersions = this.allVersions && !this.hasOldVersions;
        this.hasOldVersions = false;
        String repoId = this.getRepositoryId();
        if (ENABLED) {
            if (null != repoId) {
                this.cachePackageFeed((NugetProxyRepository)this.getRepositoryRegistry().getRepositoryWithFacet(repoId, NugetProxyRepository.class));
            } else {
                this.cachePackageFeed(this.getRepositoryRegistry().getRepositoriesWithFacet(NugetProxyRepository.class));
            }
        }
        this.hasOldVersions = this.allVersions;
        if (this.clearCache) {
            this.addParameter("clearCache", "false");
            this.scheduler.updateSchedule(this.scheduler.getTaskById(this.getId()));
        }
        return null;
    }

    protected String getAction() {
        return "Downloading NuGet feed";
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Downloading NuGet feed for repository " + this.getRepositoryName();
        }
        return "Downloading NuGet feeds for all remote NuGet repositories";
    }

    private void cachePackageFeed(List<NugetProxyRepository> proxies) throws Exception {
        for (NugetProxyRepository p : proxies) {
            this.cachePackageFeed(p);
        }
    }

    private void cachePackageFeed(NugetProxyRepository proxy) throws Exception {
        long latestUpdate;
        StringBuilder filter = new StringBuilder();
        if (!this.allVersions) {
            filter.append("&$filter=IsLatestVersion");
        }
        final String proxyId = proxy.getId();
        if (this.clearCache) {
            this.gallery.drop(proxyId);
        } else if (!this.getOldVersions && (latestUpdate = this.gallery.latestUpdate(proxyId)) != 0L) {
            filter.append(filter.length() == 0 ? "&$filter=" : "%20and%20");
            filter.append("LastUpdated%20ge%20datetime'");
            filter.append(ODataUtils.datetime(latestUpdate));
            filter.append('\'');
        }
        String query = "Packages?$orderby=LastUpdated" + filter;
        this.fetcher.cachePackageFeed(proxy, query, this.retries, true, new ODataConsumer(){

            @Override
            public void consume(Map<String, String> data) {
                DownloadNugetFeedTask.this.gallery.put(proxyId, data);
                DownloadNugetFeedTask.this.gallery.setLatestUpdate(proxyId, ODataUtils.datetime(data.get("LASTUPDATED")));
                DownloadNugetFeedTask.this.checkInterruption();
            }
        });
    }
}

