/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.shadow;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.NugetStoreRequest;
import com.sonatype.nexus.plugins.nuget.NugetUtils;
import com.sonatype.nexus.plugins.nuget.odata.NuspecSplicer;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import com.sonatype.nexus.plugins.nuget.shadow.NugetShadowRepositoryConfiguration;
import com.sonatype.nexus.plugins.nuget.shadow.NugetShadowRepositoryConfigurator;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.item.DefaultStorageLinkItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractShadowRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.IncompatibleMasterRepositoryException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

@Named(value="nuget-shadow")
@Typed(value={ShadowRepository.class})
public final class NugetShadowRepository
extends AbstractShadowRepository
implements ShadowRepository {
    public static final String ROLE_HINT = "nuget-shadow";
    private final ContentClass contentClass;
    private final NugetShadowRepositoryConfigurator configurator;
    private final NugetGallery gallery;
    private final RepositoryKind repositoryKind = new DefaultRepositoryKind(ShadowRepository.class, null);
    private ContentClass masterContentClass;

    @Inject
    public NugetShadowRepository(@Named(value="nuget") ContentClass contentClass, NugetShadowRepositoryConfigurator configurator, NugetGallery gallery) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NugetShadowRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
        this.gallery = (NugetGallery)Preconditions.checkNotNull((Object)gallery);
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NugetShadowRepositoryConfiguration>(){

            public NugetShadowRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NugetShadowRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public void setMasterRepository(Repository masterRepository) throws IncompatibleMasterRepositoryException {
        this.masterContentClass = masterRepository.getRepositoryContentClass();
        super.setMasterRepository(masterRepository);
    }

    public ContentClass getMasterRepositoryContentClass() {
        return this.masterContentClass;
    }

    protected StorageLinkItem createLink(StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        DefaultStorageLinkItem link = null;
        if (NugetUtils.isNupkg(item)) {
            try {
                Map<String, String> data = NuspecSplicer.consumeItem((StorageFileItem)item);
                this.gallery.put(this.getId(), data);
                NugetStoreRequest request = new NugetStoreRequest(data.get("ID"), data.get("VERSION"), false, false);
                request.getRequestContext().setParentContext(item.getItemContext());
                link = new DefaultStorageLinkItem((Repository)this, (ResourceStoreRequest)request, true, true, item.getRepositoryItemUid());
                this.storeItem(false, (StorageItem)link);
            }
            catch (Exception e) {
                this.log.warn("Unable to build NuGet metadata for: " + item, (Throwable)e);
            }
        }
        return link;
    }

    protected void deleteLink(StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        String location;
        String[] coords;
        if (NugetUtils.isNupkg(item) && null != (coords = this.gallery.identify(location = ODataUtils.toSQL(item.getRepositoryItemUid())))) {
            NugetStoreRequest request = new NugetStoreRequest(coords[0], coords[1], false, false);
            request.getRequestContext().setParentContext(item.getItemContext());
            try {
                this.deleteItem(false, request);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            this.gallery.delete(this.getId(), location);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove event) {
        if (event.getRepository() == this) {
            this.gallery.drop(this.getId());
        }
    }

    public void synchronizeWithMaster() {
        if (this.getLocalStatus().shouldServiceRequest()) {
            this.gallery.drop(this.getId());
        }
        super.synchronizeWithMaster();
    }
}

