/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.security;

import com.sonatype.nexus.plugins.nuget.security.NugetApiKeyStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.filter.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserStatus;

@Named(value="X-NuGet-ApiKey")
@Singleton
@Description(value="NuGet API-Key Realm")
public final class NugetApiKeyRealm
extends AuthenticatingRealm {
    @Inject
    private NugetApiKeyStore keyStore;
    @Inject
    private UserPrincipalsHelper principalsHelper;

    public String getName() {
        return "X-NuGet-ApiKey";
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof NexusApiKeyAuthenticationToken && "X-NuGet-ApiKey".equals(token.getPrincipal());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        PrincipalCollection principals = this.keyStore.getPrincipals((char[])token.getCredentials());
        if (null != principals) {
            try {
                if (UserStatus.active.equals((Object)this.principalsHelper.getUserStatus(principals))) {
                    ((NexusApiKeyAuthenticationToken)token).setPrincipal(principals.getPrimaryPrincipal());
                    return new SimpleAuthenticationInfo(principals, token.getCredentials());
                }
            }
            catch (UserNotFoundException e) {
                this.keyStore.deleteApiKey(principals);
            }
        }
        return null;
    }
}

