/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.security;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.nuget.security.NugetApiKeyStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.security.events.UserPrincipalsExpired;

@Named
@Singleton
final class NugetApiKeyEventInspector
implements EventSubscriber {
    @Inject
    private NugetApiKeyStore keyStore;

    NugetApiKeyEventInspector() {
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(UserPrincipalsExpired expiredEvent) {
        String userId = expiredEvent.getUserId();
        if (userId != null) {
            this.keyStore.deleteApiKey((PrincipalCollection)new SimplePrincipalCollection((Object)userId, expiredEvent.getSource()));
        } else {
            this.keyStore.purgeApiKeys();
        }
    }
}

