/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.nuget.NugetStoreRequest;
import com.sonatype.nexus.plugins.nuget.odata.NuspecSplicer;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import com.sonatype.nexus.plugins.nuget.proxy.NugetHostedRepository;
import com.sonatype.nexus.plugins.nuget.rest.AbstractNugetArtifactResource;
import com.sonatype.nexus.plugins.nuget.rest.GalleryUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.fileupload.FileItem;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.codehaus.plexus.util.StringUtils;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.rest.RepositoryURLBuilder;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/nuget/{r}")
@Produces(value={"application/xml", "application/json"})
@Named(value="NugetGalleryResource")
@Singleton
public final class NugetGalleryResource
extends AbstractNugetArtifactResource {
    public static final String RESOURCE_URI = "/nuget/{r}";
    private static final Pattern PACKAGE_ENTRY_PATTERN = Pattern.compile("Packages\\(\\s*Id\\s*=\\s*'([^']+)'\\s*,\\s*Version\\s*=\\s*'([^']+)'\\s*\\)");
    private final RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public NugetGalleryResource(RepositoryURLBuilder repositoryURLBuilder) {
        this.repositoryURLBuilder = (RepositoryURLBuilder)Preconditions.checkNotNull((Object)repositoryURLBuilder);
        this.setModifiable(true);
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/nuget/**", "authcApiKey");
    }

    public boolean acceptsUpload() {
        return true;
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="r")}, output=String.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Reference ref = request.getResourceRef();
        try {
            String repoId = request.getAttributes().get("r").toString();
            String endpoint = "service/local/nuget/" + repoId;
            String base = this.createReference(this.getContextRoot(request), endpoint).toString();
            String path = StringUtils.strip((String)ref.getRemainingPart(true, false), (String)"/");
            Iterable<String> memberIds = this.getMemberIds(repoId, request);
            if ("".equals(path)) {
                return GalleryUtils.xml(ODataUtils.root(base));
            }
            if ("$metadata".equals(path)) {
                return GalleryUtils.xml(ODataUtils.metadata());
            }
            if (path.startsWith(".meta")) {
                response.setLocationRef(this.repositoryURLBuilder.getRepositoryContentUrl(repoId) + '/' + path);
                response.setStatus(Status.REDIRECTION_TEMPORARY);
                return null;
            }
            if (path.endsWith("$count")) {
                return GalleryUtils.text(Integer.toString(this.gallery().count(memberIds, path, ref.getQuery())));
            }
            if ("Packages".equals(path) || "Packages()".equals(path)) {
                return GalleryUtils.xml(this.gallery().feed(memberIds, base, "Packages", ref.getQuery()));
            }
            if ("Search".equals(path) || "Search()".equals(path)) {
                return GalleryUtils.xml(this.gallery().feed(memberIds, base, "Search", ref.getQuery()));
            }
            if ("FindPackagesById".equals(path) || "FindPackagesById()".equals(path)) {
                return GalleryUtils.xml(this.gallery().feed(memberIds, base, "FindPackagesById", ref.getQuery()));
            }
            Matcher m = PACKAGE_ENTRY_PATTERN.matcher(path);
            if (m.matches()) {
                String entry = this.gallery().entry(memberIds, base, m.group(1), m.group(2));
                if (null != entry) {
                    return GalleryUtils.xml(entry);
                }
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            String[] idVersion = path.split("/");
            if (idVersion.length == 2) {
                NugetStoreRequest rsr = new NugetStoreRequest(idVersion[0], idVersion[1], false, false);
                StorageItem item = this.getNugetRepository(repoId).retrieveItem((ResourceStoreRequest)rsr);
                if (item instanceof StorageLinkItem) {
                    item = this.getRepositoryRouter().dereferenceLink((StorageLinkItem)item);
                }
                return GalleryUtils.file((StorageFileItem)item);
            }
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (Exception problem) {
            return GalleryUtils.xmlErrorMessage(request, response, this.getLogger(), problem);
        }
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="r")})
    public Object upload(Context context, Request request, Response response, List<FileItem> files) throws ResourceException {
        try {
            this.checkApiKeyAccess();
            for (FileItem item : files) {
                NugetStoreRequest req;
                try (InputStream is = item.getInputStream();){
                    Map<String, String> data = NuspecSplicer.header(is);
                    req = this.getNugetStoreRequest(request, true, false, data.get("ID"), data.get("VERSION"));
                }
                NugetHostedRepository repo = this.getNugetHostRepository(request.getAttributes().get("r").toString());
                InputStream is = item.getInputStream();
                Throwable throwable = null;
                try {
                    repo.storeItem(req, is, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return GalleryUtils.html("<html><body></body></html>");
        }
        catch (Exception problem) {
            return GalleryUtils.xmlErrorMessage(request, response, this.getLogger(), problem);
        }
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="r")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        String path = StringUtils.strip((String)request.getResourceRef().getRemainingPart(true, false), (String)"/");
        try {
            this.checkApiKeyAccess();
            String[] idVersion = path.split("/", 2);
            NugetStoreRequest req = this.getNugetStoreRequest(request, true, false, idVersion[0], idVersion[1]);
            req.setRequestPath('/' + path);
            this.getNugetHostRepository(request.getAttributes().get("r").toString()).deleteItem(req);
            response.setEntity("<html><body></body></html>", MediaType.TEXT_HTML);
        }
        catch (Exception problem) {
            GalleryUtils.throwResourceException(request, response, this.getLogger(), problem);
        }
    }
}

