/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.rest;

import com.sonatype.nexus.plugins.nuget.NugetStoreRequest;
import com.sonatype.nexus.plugins.nuget.odata.NuspecSplicer;
import com.sonatype.nexus.plugins.nuget.proxy.NugetHostedRepository;
import com.sonatype.nexus.plugins.nuget.rest.AbstractNugetArtifactResource;
import com.sonatype.nexus.plugins.nuget.rest.GalleryUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.fileupload.FileItem;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/artifact/nuget/content")
@Produces(value={"*/*"})
@Named(value="NugetArtifactContentResource")
@Singleton
public final class NugetArtifactContentResource
extends AbstractNugetArtifactResource {
    public static final String RESOURCE_URI = "/artifact/nuget/content";

    public NugetArtifactContentResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:artifact]");
    }

    public boolean acceptsUpload() {
        return true;
    }

    public Object upload(Context context, Request request, Response response, List<FileItem> files) throws ResourceException {
        try {
            String repositoryId = null;
            for (FileItem item : files) {
                NugetStoreRequest req;
                if (item.isFormField()) {
                    if (!"r".equals(item.getFieldName())) continue;
                    repositoryId = item.getString();
                    continue;
                }
                if (repositoryId == null) {
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST);
                }
                try (InputStream is = item.getInputStream();){
                    Map<String, String> data = NuspecSplicer.header(is);
                    req = this.getNugetStoreRequest(request, true, false, data.get("ID"), data.get("VERSION"));
                }
                NugetHostedRepository repo = this.getNugetHostRepository(repositoryId);
                InputStream is = item.getInputStream();
                Throwable throwable = null;
                try {
                    repo.storeItem(req, is, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return GalleryUtils.html("<html><body></body></html>");
        }
        catch (Exception problem) {
            return GalleryUtils.htmlErrorMessage(request, response, this.getLogger(), problem);
        }
    }

    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="r"), @QueryParam(value="a"), @QueryParam(value="v")}, output=String.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        return this.getContent(false, request, response);
    }
}

