/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.rest;

import com.sonatype.nexus.plugins.nuget.rest.AbstractNugetArtifactResource;
import com.sonatype.nexus.plugins.nuget.rest.GalleryUtils;
import com.sonatype.nexus.plugins.nuget.security.NugetApiKeyStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/apikeys/nuget")
@Produces(value={"application/xml", "application/json"})
@Named(value="NugetApiKeysResource")
@Singleton
public final class NugetApiKeysResource
extends AbstractNugetArtifactResource {
    public static final String RESOURCE_URI = "/apikeys/nuget";
    public static final String NUGET_REALM_MESSAGE = "The NuGet API-Key Security Realm is currently disabled in Nexus.<br/>Go to Administration \u2192 Server \u2192 Security Settings to enable it.";
    @Inject
    private Provider<NugetApiKeyStore> keyStore;

    public boolean isModifiable() {
        return true;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[apikey:access]");
    }

    @GET
    @ResourceMethodSignature(output=String.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        try {
            if (!this.hasApiKeyRealm()) {
                throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED, NUGET_REALM_MESSAGE);
            }
            char[] apiKey = ((NugetApiKeyStore)this.keyStore.get()).getApiKey(this.currentPrincipals());
            if (null == apiKey) {
                apiKey = ((NugetApiKeyStore)this.keyStore.get()).createApiKey(this.currentPrincipals());
            }
            return GalleryUtils.text(new String(apiKey));
        }
        catch (Exception problem) {
            return GalleryUtils.htmlErrorMessage(request, response, this.getLogger(), problem);
        }
    }

    @POST
    @ResourceMethodSignature(output=String.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        try {
            if (!this.hasApiKeyRealm()) {
                throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED, NUGET_REALM_MESSAGE);
            }
            return GalleryUtils.text(new String(((NugetApiKeyStore)this.keyStore.get()).createApiKey(this.currentPrincipals())));
        }
        catch (Exception problem) {
            return GalleryUtils.htmlErrorMessage(request, response, this.getLogger(), problem);
        }
    }
}

