/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.rest;

import com.google.common.base.Strings;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import java.io.IOException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.rest.AbstractResourceStoreContentPlexusResource;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.StorageFileItemRepresentation;

public final class GalleryUtils {
    public static Object xmlErrorMessage(Request request, Response response, Logger log, Exception cause) {
        String error;
        Status status;
        block3: {
            status = null;
            error = "unknown";
            try {
                GalleryUtils.throwResourceException(request, response, log, cause);
            }
            catch (ResourceException e) {
                Reference ref = request.getResourceRef();
                log.debug("Error handling: " + ref, (Throwable)cause);
                if (!Boolean.parseBoolean(ref.getQueryAsForm().getFirstValue("forceSuccess"))) {
                    status = e.getStatus();
                    response.setStatus(status);
                }
                if (!(error = Strings.nullToEmpty((String)e.getMessage())).contains("SQL")) break block3;
                error = "Bad Request - Error in query syntax.";
            }
        }
        return ODataUtils.error(null != status ? status.getCode() : 200, error);
    }

    public static Object htmlErrorMessage(Request request, Response response, Logger log, Exception cause) {
        String error = "unknown";
        try {
            GalleryUtils.throwResourceException(request, response, log, cause);
        }
        catch (ResourceException e) {
            Reference ref = request.getResourceRef();
            log.debug("Error handling: " + ref, (Throwable)cause);
            if (!Boolean.parseBoolean(ref.getQueryAsForm().getFirstValue("forceSuccess"))) {
                response.setStatus(e.getStatus());
            }
            error = e.getMessage();
        }
        return GalleryUtils.html("<html><body><error>" + error + "</error></body></html>");
    }

    public static Object throwResourceException(Request request, Response response, Logger log, Exception cause) throws ResourceException {
        if (cause instanceof ResourceException) {
            throw (ResourceException)((Object)cause);
        }
        if (cause instanceof RepositoryNotAvailableException) {
            throw new ResourceException(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, cause.getMessage());
        }
        if (cause instanceof IllegalArgumentException) {
            log.info("Illegal argument: {}", (Object)cause.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, cause.getMessage());
        }
        if (cause instanceof IllegalRequestException) {
            log.info("Illegal request: {}", (Object)cause.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, cause.getMessage());
        }
        if (cause instanceof IllegalOperationException) {
            log.info("Illegal operation: {}", (Object)cause.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, cause.getMessage());
        }
        if (cause instanceof StorageException) {
            log.warn("I/O problem!", (Throwable)cause);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, cause.getMessage());
        }
        if (cause instanceof UnsupportedStorageOperationException) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, cause.getMessage());
        }
        if (cause instanceof NoSuchRepositoryAccessException) {
            AbstractResourceStoreContentPlexusResource.challengeIfNeeded((Request)request, (Response)response, (AccessDeniedException)new AccessDeniedException(cause.getMessage()));
            throw new ResourceException(response.getStatus());
        }
        if (cause instanceof NoSuchResourceStoreException) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, cause.getMessage());
        }
        if (cause instanceof ItemNotFoundException) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, cause.getMessage());
        }
        if (cause instanceof AccessDeniedException) {
            AbstractResourceStoreContentPlexusResource.challengeIfNeeded((Request)request, (Response)response, (AccessDeniedException)((AccessDeniedException)cause));
            throw new ResourceException(response.getStatus());
        }
        if (cause instanceof XmlPullParserException) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, cause.getMessage());
        }
        if (cause instanceof IOException) {
            log.warn("I/O error!", (Throwable)cause);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, cause.getMessage());
        }
        log.warn(cause.getMessage() != null ? cause.getMessage() : "Unknown problem", (Throwable)cause);
        throw new ResourceException(Status.SERVER_ERROR_INTERNAL, cause.getMessage());
    }

    public static Representation text(String text) {
        return new StringRepresentation((CharSequence)text, MediaType.TEXT_PLAIN, null, CharacterSet.UTF_8);
    }

    public static Representation html(String html) {
        return new StringRepresentation((CharSequence)html, MediaType.TEXT_HTML, null, CharacterSet.UTF_8);
    }

    public static Representation xml(String xml) {
        return new StringRepresentation((CharSequence)xml, MediaType.APPLICATION_XML, null, CharacterSet.UTF_8);
    }

    public static Representation file(StorageFileItem file) {
        StorageFileItemRepresentation representation = new StorageFileItemRepresentation(file);
        representation.setDownloadable(true);
        representation.setDownloadName(file.getName());
        return representation;
    }
}

