/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.rest;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.plugins.nuget.NugetContentClass;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.NugetStoreRequest;
import com.sonatype.nexus.plugins.nuget.proxy.NugetHostedRepository;
import com.sonatype.nexus.plugins.nuget.rest.GalleryUtils;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.security.SecuritySystem;

public abstract class AbstractNugetArtifactResource
extends AbstractNexusPlexusResource {
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    @Named(value="passthrough")
    private Provider<NugetGallery> gallery;

    protected final NugetGallery gallery() {
        return (NugetGallery)this.gallery.get();
    }

    public List<Variant> getVariants() {
        List result = super.getVariants();
        result.add(0, new Variant(MediaType.TEXT_HTML));
        result.add(new Variant(MediaType.TEXT_PLAIN));
        return result;
    }

    protected final Object getNuget(Request request, Response response) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        String repositoryId = form.getFirstValue("r");
        String artifactId = form.getFirstValue("a");
        String version = form.getFirstValue("v");
        if (repositoryId == null || artifactId == null || version == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        String endpoint = "service/local/nuget/" + repositoryId;
        String base = this.createReference(this.getContextRoot(request), endpoint).toString();
        try {
            return GalleryUtils.xml(this.gallery().entry(this.getMemberIds(repositoryId, request), base, artifactId, version));
        }
        catch (Exception problem) {
            return GalleryUtils.throwResourceException(request, response, this.getLogger(), problem);
        }
    }

    protected final Object getContent(boolean redirect, Request request, Response response) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        String repositoryId = form.getFirstValue("r");
        String artifactId = form.getFirstValue("a");
        String version = form.getFirstValue("v");
        if (repositoryId == null || artifactId == null || version == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        NugetStoreRequest req = this.getNugetStoreRequest(request, false, false, artifactId, version);
        req.setRequestLocalOnly(this.isLocal(request, req.getRequestPath()));
        try {
            StorageItem item = this.getNugetRepository(repositoryId).retrieveItem((ResourceStoreRequest)req);
            if (redirect) {
                RepositoryItemUid uid = item.getRepositoryItemUid();
                response.setLocationRef(this.createRepositoryReference(request, uid.getRepository().getId(), uid.getPath()));
                response.setStatus(Status.REDIRECTION_TEMPORARY);
                return GalleryUtils.html("If you are not automatically redirected use this url: " + response.getLocationRef());
            }
            return GalleryUtils.file((StorageFileItem)item);
        }
        catch (Exception problem) {
            return GalleryUtils.throwResourceException(request, response, this.getLogger(), problem);
        }
    }

    protected final NugetHostedRepository getNugetHostRepository(String id) throws ResourceException, NoSuchRepositoryException {
        Repository repo = this.getUnprotectedRepositoryRegistry().getRepository(id);
        if (!repo.getRepositoryKind().isFacetAvailable(NugetHostedRepository.class)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "This is not a NuGet hosted repository!");
        }
        return (NugetHostedRepository)repo.adaptToFacet(NugetHostedRepository.class);
    }

    protected final Repository getNugetRepository(String id) throws ResourceException, NoSuchRepositoryException {
        Repository repo = this.getUnprotectedRepositoryRegistry().getRepository(id);
        if (!(repo.getRepositoryContentClass() instanceof NugetContentClass)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "This is not a NuGet repository!");
        }
        return repo;
    }

    protected final Iterable<String> getMemberIds(String repositoryId, Request request) throws Exception {
        Repository repository = this.getNugetRepository(repositoryId);
        ResourceStoreRequest rsr = this.contextualize(request, new ResourceStoreRequest("/"));
        AbstractNugetArtifactResource.checkReadAccess(repository, rsr);
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Repository member : ((GroupRepository)repository.adaptToFacet(GroupRepository.class)).getTransitiveMemberRepositories()) {
                try {
                    AbstractNugetArtifactResource.checkReadAccess(member, rsr);
                    ids.add(member.getId());
                }
                catch (Exception e) {
                    this.getLogger().debug("Skipping '" + member.getId() + "'", (Throwable)e);
                }
            }
            return ids;
        }
        return ImmutableList.of((Object)repositoryId);
    }

    protected final NugetStoreRequest getNugetStoreRequest(Request request, boolean localOnly, boolean remoteOnly, String a, String v) {
        NugetStoreRequest req = new NugetStoreRequest(a, v, localOnly, remoteOnly);
        this.getLogger().debug("Created NugetStoreRequest request for " + req.getRequestPath());
        return this.contextualize(request, req);
    }

    protected final <T extends ResourceStoreRequest> T contextualize(Request request, T result) {
        result.getRequestContext().put("request.address", (Object)this.getValidRemoteIPAddress(request));
        Subject subject = this.securitySystem.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            result.getRequestContext().put("request.user", (Object)subject.getPrincipal().toString());
        }
        result.getRequestContext().put("request.agent", (Object)request.getClientInfo().getAgent());
        if (request.isConfidential()) {
            result.getRequestContext().put("request.isConfidential", (Object)Boolean.TRUE);
            List certs = (List)request.getAttributes().get("org.restlet.https.clientCertificates");
            if (certs != null) {
                result.getRequestContext().put("request.certificates", (Object)certs);
            }
        }
        result.setRequestUrl(request.getOriginalRef().toString());
        return result;
    }

    protected static final void checkReadAccess(Repository repository, ResourceStoreRequest request) throws AccessDeniedException, RepositoryNotAvailableException {
        if (!repository.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(repository);
        }
        repository.getAccessManager().decide(repository, request, Action.read);
    }

    protected final boolean hasApiKeyRealm() {
        return this.securitySystem.getRealms().contains("X-NuGet-ApiKey");
    }

    protected final void checkApiKeyAccess() {
        this.securitySystem.getSubject().checkPermission("apikey:access");
    }

    protected final PrincipalCollection currentPrincipals() {
        return this.securitySystem.getSubject().getPrincipals();
    }
}

