/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.proxy;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepositoryConfigurator;
import org.sonatype.nexus.proxy.repository.ItemContentValidator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;

@Named
@Singleton
public final class NugetRepositoryConfigurator
extends AbstractProxyRepositoryConfigurator {
    private final ItemContentValidator fileTypeItemContentValidator;

    @Inject
    public NugetRepositoryConfigurator(@Named(value="FileTypeItemContentValidator") ItemContentValidator fileTypeItemContentValidator) {
        this.fileTypeItemContentValidator = (ItemContentValidator)Preconditions.checkNotNull((Object)fileTypeItemContentValidator);
    }

    public void doApplyConfiguration(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfiguration) throws ConfigurationException {
        super.doApplyConfiguration(repository, configuration, coreConfiguration);
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            ProxyRepository proxy = (ProxyRepository)repository.adaptToFacet(ProxyRepository.class);
            proxy.getItemContentValidators().put("filetypevalidator", this.fileTypeItemContentValidator);
        }
    }
}

