/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.proxy;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.NugetStoreRequest;
import com.sonatype.nexus.plugins.nuget.NugetUtils;
import com.sonatype.nexus.plugins.nuget.odata.FeedSplicer;
import com.sonatype.nexus.plugins.nuget.odata.NuspecSplicer;
import com.sonatype.nexus.plugins.nuget.odata.ODataConsumer;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import com.sonatype.nexus.plugins.nuget.proxy.NugetHostedRepository;
import com.sonatype.nexus.plugins.nuget.proxy.NugetProxyRepository;
import com.sonatype.nexus.plugins.nuget.proxy.NugetRepositoryConfiguration;
import com.sonatype.nexus.plugins.nuget.proxy.NugetRepositoryConfigurator;
import com.sonatype.nexus.plugins.nuget.tasks.DownloadNugetFeedTask;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RemoteAccessException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.MutableProxyRepositoryKind;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.scheduling.ScheduledTask;

@Named(value="nuget-proxy")
@Typed(value={Repository.class})
public final class NugetRepository
extends AbstractProxyRepository
implements NugetProxyRepository,
NugetHostedRepository,
Repository {
    public static final String ROLE_HINT = "nuget-proxy";
    public static final String FEED_TASK_SUFFIX = " (NuGet Feed)";
    private static final Pattern CONTENT_PATTERN = Pattern.compile("(.+)/content/(?:repositories|groups|shadows)/(.+)");
    private static final String NUGET_SERVICE_PATH = "/service/local/nuget/";
    private final ContentClass contentClass;
    private final NugetRepositoryConfigurator configurator;
    private final NexusScheduler scheduler;
    private final NugetGallery gallery;
    private final ApplicationStatusSource applicationStatusSource;
    private final RepositoryKind repositoryKind = new MutableProxyRepositoryKind((ProxyRepository)this, null, (RepositoryKind)new DefaultRepositoryKind(NugetHostedRepository.class, null), (RepositoryKind)new DefaultRepositoryKind(NugetProxyRepository.class, null));

    @Inject
    public NugetRepository(@Named(value="nuget") ContentClass contentClass, NugetRepositoryConfigurator configurator, NexusScheduler scheduler, @Named(value="passthrough") NugetGallery gallery, ApplicationStatusSource applicationStatusSource) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NugetRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
        this.scheduler = (NexusScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.gallery = (NugetGallery)Preconditions.checkNotNull((Object)gallery);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NugetRepositoryConfiguration>(){

            public NugetRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NugetRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    protected NugetRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        return (NugetRepositoryConfiguration)super.getExternalConfiguration(forModification);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryItemEventStore event) {
        StorageItem item;
        if (event.getRepository() == this && NugetUtils.isNupkg(item = event.getItem())) {
            try {
                this.gallery.put(this.getId(), NuspecSplicer.consumeItem((StorageFileItem)item));
            }
            catch (Exception e) {
                this.log.warn("Unable to build NuGet metadata for: " + item, (Throwable)e);
            }
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryItemEventDelete event) {
        StorageItem item;
        if (event.getRepository() == this && NugetUtils.isNupkg(item = event.getItem())) {
            this.gallery.delete(this.getId(), ODataUtils.toSQL(item.getRepositoryItemUid()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove event) {
        if (event.getRepository() == this) {
            if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && this.applicationStatusSource.getSystemStatus().isNexusStarted()) {
                this.unscheduleFeedTasks();
            }
            this.gallery.drop(this.getId());
        }
    }

    @Override
    public String getGalleryUrl() {
        String url = this.getRemoteUrl();
        Matcher m = CONTENT_PATTERN.matcher(url);
        if (m.matches()) {
            url = m.group(1) + NUGET_SERVICE_PATH + m.group(2);
        }
        return url;
    }

    @Override
    public int getArtifactMaxAge() {
        return this.getExternalConfiguration(false).getArtifactMaxAge();
    }

    @Override
    public void setArtifactMaxAge(int maxAge) {
        this.getExternalConfiguration(true).setArtifactMaxAge(maxAge);
    }

    protected boolean isOld(StorageItem item) {
        return this.isOld(this.getArtifactMaxAge(), item);
    }

    protected boolean doCheckRemoteItemExistence(StorageItem localItem, ResourceStoreRequest request) throws RemoteAccessException, RemoteStorageException {
        return true;
    }

    protected AbstractStorageItem doRetrieveRemoteItem(ResourceStoreRequest request) throws ItemNotFoundException, RemoteAccessException, StorageException {
        try {
            AbstractStorageItem item;
            ResourceStoreRequest link;
            NugetStoreRequest nupkg = new NugetStoreRequest(request.getRequestPath(), false, false);
            String id = nupkg.getId();
            String version = nupkg.getVersion();
            String baseUrl = this.getGalleryUrl();
            String location = this.gallery.locate((Iterable<String>)ImmutableList.of((Object)this.getId()), id, version);
            if (null == location) {
                try {
                    String query = "Packages(Id='" + id + "',Version='" + version + "')";
                    link = new ResourceStoreRequest(query);
                    item = this.getRemoteStorage().retrieveItem((ProxyRepository)this, link, baseUrl);
                    try (InputStream is = ((StorageFileItem)item).getInputStream();){
                        FeedSplicer feedSplicer = new FeedSplicer(new ODataConsumer(){

                            @Override
                            public void consume(Map<String, String> data) {
                                NugetRepository.this.gallery.put(NugetRepository.this.getId(), data);
                            }
                        });
                        location = feedSplicer.consumeEntry(is).get("LOCATION");
                    }
                }
                catch (Exception ignore) {
                    this.log.debug("Ignoring exception", (Throwable)ignore);
                }
                if (null == location) {
                    if (baseUrl.contains(NUGET_SERVICE_PATH)) {
                        location = id + '/' + version;
                    } else {
                        throw new ItemNotFoundException(request);
                    }
                }
            }
            if (location.startsWith("http:") || location.startsWith("https:")) {
                int n = StringUtils.stripEnd((String)location, (String)"/").lastIndexOf(47);
                link = new ResourceStoreRequest(location.substring(n));
                item = this.getRemoteStorage().retrieveItem((ProxyRepository)this, link, location.substring(0, n));
            } else {
                ResourceStoreRequest link2 = new ResourceStoreRequest(location);
                item = this.getRemoteStorage().retrieveItem((ProxyRepository)this, link2, baseUrl);
            }
            nupkg.getRequestContext().setParentContext(item.getItemContext());
            item.setRepositoryItemUid(this.createUid(nupkg.getRequestPath()));
            item.setResourceStoreRequest((ResourceStoreRequest)nupkg);
            item = this.doCacheItem(item);
            ArrayList events = new ArrayList();
            boolean isValid = this.doValidateRemoteItemContent(request, baseUrl, item, events);
            for (RepositoryItemValidationEvent event : events) {
                this.eventBus().post((Object)event);
            }
            if (isValid) {
                return item;
            }
            try {
                this.getLocalStorage().deleteItem((Repository)this, request);
            }
            catch (ItemNotFoundException is) {
            }
            catch (UnsupportedStorageOperationException e) {
                this.log.warn("Unexpected Exception", (Throwable)e);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new ItemNotFoundException(request, (Repository)this);
    }

    private List<ScheduledTask<?>> findScheduledFeedTasks() {
        List tasks = (List)this.scheduler.getAllTasks().get(DownloadNugetFeedTask.class.getSimpleName());
        ArrayList matching = Lists.newArrayList();
        if (null != tasks) {
            String id = this.getId();
            for (ScheduledTask task : tasks) {
                Callable callable = task.getTask();
                if (!(callable instanceof DownloadNugetFeedTask) || !Objects.equal((Object)id, (Object)((DownloadNugetFeedTask)((Object)callable)).getRepositoryId())) continue;
                matching.add(task);
            }
        }
        return matching;
    }

    private void unscheduleFeedTasks() {
        for (ScheduledTask<?> feedTask : this.findScheduledFeedTasks()) {
            try {
                if (null == feedTask) continue;
                feedTask.cancel(true);
            }
            catch (Exception e) {
                this.log.warn("Unable to unschedule NuGet feed task for: {}", (Object)this.getId(), (Object)e);
            }
        }
    }
}

