/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.proxy;

import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.plugins.nuget.NugetUtils;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.validator.AbstractMimeMagicFileTypeValidator;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidator;

@Named(value="nuget")
@Singleton
public final class NugetFileTypeValidator
extends AbstractMimeMagicFileTypeValidator {
    @Inject
    public NugetFileTypeValidator(MimeSupport mimeSupport) {
        super(mimeSupport);
    }

    public FileTypeValidator.FileTypeValidity isExpectedFileType(StorageFileItem item) {
        if (NugetUtils.isNupkg((StorageItem)item)) {
            try {
                return this.isExpectedFileTypeByDetectedMimeType(item, (Set)ImmutableSet.of((Object)"application/zip"), false);
            }
            catch (IOException e) {
                this.log.warn("Cannot validate content of: " + item.getRepositoryItemUid(), (Throwable)e);
            }
        }
        return FileTypeValidator.FileTypeValidity.NEUTRAL;
    }
}

