/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.passthrough;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.feed.NugetFeedFetcher;
import com.sonatype.nexus.plugins.nuget.odata.ODataConsumer;
import com.sonatype.nexus.plugins.nuget.passthrough.CountReportingPolicy;
import com.sonatype.nexus.plugins.nuget.proxy.NugetProxyRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.Repository;

@Singleton
@Named(value="passthrough")
public class PassThroughNugetGallery
implements NugetGallery {
    private RepositoryRegistry repositoryRegistry;
    private final NugetGallery inner;
    private final NugetFeedFetcher fetcher;
    private final Cache<QueryCacheKey, Integer> cache;
    private static final Logger log = LoggerFactory.getLogger(PassThroughNugetGallery.class);
    private static final int TWO_PAGES = 80;
    public static final Pattern COUNT_REGEX = Pattern.compile("<m:count>(\\d*)</m:count>");

    @Inject
    public PassThroughNugetGallery(@Named(value="odata") NugetGallery inner, NugetFeedFetcher fetcher, @Named(value="${nexus-nuget-query-cache-size:-300}") int cacheSize, @Named(value="${nexus-nuget-query-cache-max-age-seconds:-3600}") int cacheItemMaxAge) {
        this.fetcher = (NugetFeedFetcher)Preconditions.checkNotNull((Object)fetcher);
        this.inner = (NugetGallery)Preconditions.checkNotNull((Object)inner);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)cacheItemMaxAge, TimeUnit.SECONDS).build();
    }

    @Inject
    public void setRepositoryRegistry(RepositoryRegistry registry) {
        this.repositoryRegistry = registry;
    }

    @Override
    public int count(Iterable<String> repositoryIds, String path, String query) {
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(repositoryIds, path, query, new CountFetcher(this.fetcher));
        int totalPackagesRemotelyAvailable = this.sum(remoteCounts);
        Iterable<Repository> nonProxies = this.filterByFacet(repositoryIds, NugetProxyRepository.class, false);
        FluentIterable nonProxyIds = FluentIterable.from(nonProxies).transform((Function)new Function<Repository, String>(){

            @Nullable
            public String apply(@Nullable Repository input) {
                return input.getId();
            }
        });
        int locallyHostedPackages = this.inner.count((Iterable<String>)nonProxyIds, path, query);
        return locallyHostedPackages + totalPackagesRemotelyAvailable;
    }

    @Override
    public String feed(Iterable<String> repositoryIds, String base, String name, String query) {
        Integer top = this.getParameter(query, "$top");
        Integer skip = this.getParameter(query, "$skip");
        String remoteQuery = query;
        boolean searching = "Search".equals(name);
        if (searching && top != null && skip != null) {
            remoteQuery = query.replaceAll("top=\\d*", "top=80").replaceAll("skip=\\d*", "skip=0");
        } else if (top == null) {
            remoteQuery = "$top=80&" + query;
        } else if (top > 80) {
            remoteQuery = query.replaceAll("top=\\d*", "top=80");
        }
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(repositoryIds, name, remoteQuery, new FeedLoader(this.fetcher, this.inner));
        String feedXml = this.inner.feed(repositoryIds, base, name, query);
        int localCount = this.parseCount(feedXml);
        int reportedCount = CountReportingPolicy.determineReportedCount(remoteCounts, localCount, top, skip);
        if (searching) {
            reportedCount = Math.min(40, reportedCount);
        }
        return feedXml.replaceFirst("<m:count>\\d*</m:count>", "<m:count>" + reportedCount + "</m:count>");
    }

    @Override
    public String entry(Iterable<String> repositoryIds, String base, String id, String version) {
        String entryXml = this.inner.entry(repositoryIds, base, id, version);
        if (entryXml == null) {
            String remoteQuery = "Packages(Id='" + id + "',Version='" + version + "')";
            for (Repository repo : this.filterByFacet(repositoryIds, NugetProxyRepository.class, true)) {
                try {
                    final NugetProxyRepository proxy = (NugetProxyRepository)repo;
                    ProxyMode proxyMode = proxy.getProxyMode();
                    if (proxyMode != null && !proxyMode.shouldProxy()) continue;
                    this.fetcher.cachePackageFeed(proxy, remoteQuery, 2, false, new ODataConsumer(){

                        @Override
                        public void consume(Map<String, String> data) {
                            PassThroughNugetGallery.this.inner.put(proxy.getId(), data);
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getId(), (Object)e);
                }
            }
            entryXml = this.inner.entry(repositoryIds, base, id, version);
        }
        return entryXml;
    }

    @Override
    public String locate(Iterable<String> repositoryIds, String id, String version) {
        return this.inner.locate(repositoryIds, id, version);
    }

    @Override
    public String[] identify(String location) {
        return this.inner.identify(location);
    }

    @Override
    public boolean put(String repositoryId, Map<String, String> data) {
        return this.inner.put(repositoryId, data);
    }

    @Override
    public boolean delete(String repositoryId, String location) {
        return this.inner.delete(repositoryId, location);
    }

    @Override
    public long latestUpdate(String repositoryId) {
        return this.inner.latestUpdate(repositoryId);
    }

    @Override
    public void setLatestUpdate(String repositoryId, long time) {
        this.inner.setLatestUpdate(repositoryId, time);
    }

    @Override
    public int drop(String repositoryId) {
        this.cache.invalidateAll();
        return this.inner.drop(repositoryId);
    }

    private int sum(Iterable<Integer> remoteCounts) {
        int sum = 0;
        for (Integer remoteCount : (Iterable)Preconditions.checkNotNull(remoteCounts)) {
            sum += ((Integer)Preconditions.checkNotNull((Object)remoteCount)).intValue();
        }
        return sum;
    }

    @Nullable
    private Integer getParameter(String query, String paramName) {
        Parameter pageSize = new Form(query).getFirst(paramName);
        if (pageSize == null) {
            return null;
        }
        String value = pageSize.getValue();
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private List<Integer> passQueryToRemoteRepos(Iterable<String> repositoryIds, String name, String query, RemoteQueryFactory creator) {
        ArrayList<Integer> packageCounts = new ArrayList<Integer>();
        for (Repository repo : this.filterByFacet(repositoryIds, NugetProxyRepository.class, true)) {
            try {
                NugetProxyRepository proxy = (NugetProxyRepository)repo;
                ProxyMode proxyMode = proxy.getProxyMode();
                if (proxyMode != null && !proxyMode.shouldProxy()) continue;
                QueryCacheKey key = new QueryCacheKey(repo.getId(), name, query);
                Integer count = (Integer)this.cache.get((Object)key, creator.createValueLoader(proxy, proxy.getId(), name, query));
                packageCounts.add(count);
            }
            catch (ExecutionException e) {
                log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getId(), (Object)e);
            }
        }
        return packageCounts;
    }

    private Iterable<Repository> filterByFacet(Iterable<String> repositoryIds, Class facet, boolean include) {
        ArrayList<Repository> successful = new ArrayList<Repository>();
        try {
            for (String repoId : repositoryIds) {
                Repository repository = this.repositoryRegistry.getRepository(repoId);
                if (repository.getRepositoryKind().isFacetAvailable(facet) != include) continue;
                successful.add(repository);
            }
        }
        catch (NoSuchRepositoryException e) {
            Throwables.propagate((Throwable)e);
        }
        return successful;
    }

    private int parseCount(String feed) {
        Matcher matcher = COUNT_REGEX.matcher(feed);
        if (!matcher.find()) {
            return 0;
        }
        String group = matcher.group(1);
        try {
            return Integer.parseInt(group);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static class QueryCacheKey {
        final String name;
        final String query;
        final String repoId;

        private QueryCacheKey(String repoId, String name, String query) {
            this.repoId = repoId;
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public String getRepoId() {
            return this.repoId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheKey that = (QueryCacheKey)o;
            if (!com.google.common.base.Objects.equal((Object)this.name, (Object)that.name)) {
                return false;
            }
            if (!com.google.common.base.Objects.equal((Object)this.query, (Object)that.query)) {
                return false;
            }
            return com.google.common.base.Objects.equal((Object)this.repoId, (Object)that.repoId);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.query, this.repoId);
        }
    }

    private static class CountFetcher
    extends RemoteQueryFactory {
        private CountFetcher(NugetFeedFetcher fetcher) {
            super(fetcher);
        }

        @Override
        public Callable<Integer> createValueLoader(final NugetProxyRepository remote, String repoId, final String name, final String query) {
            return new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return CountFetcher.this.nullToZero(CountFetcher.this.fetcher.getCount(remote, name + "?" + query));
                }
            };
        }
    }

    private static class FeedLoader
    extends RemoteQueryFactory {
        private final NugetGallery gallery;

        private FeedLoader(NugetFeedFetcher fetcher, NugetGallery gallery) {
            super(fetcher);
            this.gallery = gallery;
        }

        @Override
        public Callable<Integer> createValueLoader(final NugetProxyRepository remote, final String repoId, final String name, final String query) {
            return new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Integer remoteCount = FeedLoader.this.fetcher.cachePackageFeed(remote, name + "?" + query, 2, true, new ODataConsumer(){

                        @Override
                        public void consume(Map<String, String> data) {
                            FeedLoader.this.gallery.put(repoId, data);
                        }
                    });
                    return FeedLoader.this.nullToZero(remoteCount);
                }
            };
        }
    }

    private static abstract class RemoteQueryFactory {
        protected final NugetFeedFetcher fetcher;

        protected RemoteQueryFactory(NugetFeedFetcher fetcher) {
            this.fetcher = fetcher;
        }

        public abstract Callable<Integer> createValueLoader(NugetProxyRepository var1, String var2, String var3, String var4);

        protected Integer nullToZero(Integer input) {
            return input == null ? 0 : input;
        }
    }
}

