/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.plugins.nuget.odata.ODataNugetGallery;
import com.sonatype.nexus.plugins.nuget.odata.ODataTemplates;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.Expression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.jpa.JPASkipToken;
import org.odata4j.producer.jpa.JPQLGenerator;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.restlet.data.Form;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;

public final class ODataUtils {
    public static final int PAGE_SIZE = 40;
    private static final DateTimeFormatter ISO_PRINTER = ISODateTimeFormat.dateTime().withLocale(Locale.ENGLISH).withZoneUTC();
    private static final DateTimeFormatter ISO_PARSER = ISODateTimeFormat.dateTimeParser().withLocale(Locale.ENGLISH).withZoneUTC();

    public static String root(String base) {
        ImmutableMap data = ImmutableMap.of((Object)"BASEURI", (Object)base);
        return ODataTemplates.interpolate(ODataTemplates.NUGET_ROOT, data);
    }

    public static String metadata() {
        return ODataTemplates.NUGET_META;
    }

    public static String error(int code, String message) {
        ImmutableMap data = ImmutableMap.of((Object)"CODE", (Object)Integer.toString(code), (Object)"MESSAGE", (Object)message);
        return ODataTemplates.interpolate(ODataTemplates.NUGET_ERROR, data);
    }

    public static String datetime(long millis) {
        return ISO_PRINTER.print(millis);
    }

    public static long datetime(String millis) {
        return ISO_PARSER.parseMillis(millis);
    }

    public static String toSQL(RepositoryItemUid uid) {
        return "nexus:" + uid.getKey();
    }

    public static String query(String select, Form form) {
        QueryInfo odata;
        String id;
        StringBuilder sql = new StringBuilder(select);
        boolean hasTerms = false;
        for (String term : StringUtils.strip((String)form.getFirstValue("searchTerm", true, ""), (String)"\" '").split("[+\\s]+")) {
            if (!StringUtils.isNotBlank((String)term)) continue;
            term = org.h2.util.StringUtils.quoteStringSQL((String)('%' + term + '%'));
            if (!hasTerms) {
                sql.append("AND (");
                hasTerms = true;
            } else {
                sql.append(" OR ");
            }
            sql.append("P.ID LIKE ").append(term);
            sql.append(" OR P.TITLE LIKE ").append(term);
            sql.append(" OR P.DESCRIPTION LIKE ").append(term);
            sql.append(" OR P.TAGS LIKE ").append(term);
            sql.append(" OR P.AUTHORS LIKE ").append(term);
        }
        if (hasTerms) {
            sql.append(")");
        }
        if ((id = StringUtils.strip((String)form.getFirstValue("id", true), (String)"\" '")) != null) {
            sql.append(" AND P.ID = ").append(org.h2.util.StringUtils.quoteStringSQL((String)id));
        }
        if ("false".equalsIgnoreCase(StringUtils.strip((String)form.getFirstValue("includePrerelease", true), (String)"\" '"))) {
            sql.append(" AND NOT P.ISPRERELEASE");
        }
        try {
            odata = new QueryInfo(null, OptionsQueryParser.parseTop((String)form.getFirstValue("$top", true)), OptionsQueryParser.parseSkip((String)form.getFirstValue("$skip", true)), OptionsQueryParser.parseFilter((String)form.getFirstValue("$filter", true)), OptionsQueryParser.parseOrderBy((String)form.getFirstValue("$orderby", true)), OptionsQueryParser.parseSkipToken((String)form.getFirstValue("$skiptoken", true)), null, null, null);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Bad Request - Error in query syntax.", e);
        }
        JPQLGenerator generator = new JPQLGenerator(null, "P", ODataNugetGallery.COLUMN_ALIASES);
        if (odata.filter != null) {
            sql.append(" AND (").append(generator.toJpql(odata.filter)).append(')');
        }
        if (odata.skipToken != null) {
            sql.append(" AND (").append(generator.toJpql(JPASkipToken.parse(null, (List)odata.orderBy, (String)odata.skipToken, (String[])new String[]{"ID", "VERSION"}))).append(')');
        }
        if (!select.contains("COUNT(")) {
            sql.append(" ORDER BY ");
            if (null != odata.orderBy) {
                int size = odata.orderBy.size();
                for (int i = 0; i < size; ++i) {
                    OrderByExpression o = (OrderByExpression)odata.orderBy.get(i);
                    sql.append(generator.toJpql(o.getExpression()));
                    if (o.getDirection() == OrderByExpression.Direction.DESCENDING) {
                        sql.append(" DESC");
                    }
                    sql.append(',');
                }
            }
            sql.append("P.ID,P.VERSION");
            int top = 40;
            if (odata.top != null && odata.top < top) {
                top = odata.top;
            }
            sql.append(" LIMIT " + top);
            if (odata.skip != null) {
                sql.append(" OFFSET " + odata.skip);
            }
        }
        return sql.toString();
    }

    public static String skipLink(Form form, Map<String, ?> data) {
        String top;
        String orderby;
        String filter;
        String id;
        StringBuilder link = new StringBuilder();
        String searchterm = form.getFirstValue("searchterm", true);
        if (null != searchterm) {
            link.append("searchterm=").append(ODataUtils.encode(searchterm)).append("&amp;");
        }
        if (null != (id = form.getFirstValue("id", true))) {
            link.append("id=").append(ODataUtils.encode(id)).append("&amp;");
        }
        if (null != (filter = form.getFirstValue("$filter", true))) {
            link.append("$filter=").append(ODataUtils.encode(filter)).append("&amp;");
        }
        if (null != (orderby = form.getFirstValue("$orderby", true))) {
            link.append("$orderby=").append(ODataUtils.encode(orderby)).append("&amp;");
        }
        if (null != (top = form.getFirstValue("$top", true))) {
            link.append("$top=").append(Integer.parseInt(top) - 40).append("&amp;");
        }
        String skipToken = ODataUtils.skipToken(orderby, data);
        link.append("$skiptoken=").append(ODataUtils.encode(skipToken));
        return link.toString();
    }

    public static String skipToken(String orderBy, Map<String, ?> data) {
        StringBuilder token = new StringBuilder();
        if (null != orderBy) {
            for (OrderByExpression o : OptionsQueryParser.parseOrderBy((String)orderBy)) {
                String name = ((EntitySimpleProperty)o.getExpression()).getPropertyName();
                Object value = data.get(name.toUpperCase(Locale.ENGLISH));
                token.append(Expression.asFilterString((CommonExpression)Expression.literal(value))).append(',');
            }
        }
        token.append(Expression.asFilterString((CommonExpression)Expression.literal(data.get("ID")))).append(',');
        token.append(Expression.asFilterString((CommonExpression)Expression.literal(data.get("VERSION"))));
        return token.toString();
    }

    private static String encode(String raw) {
        try {
            return URLEncoder.encode(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return raw;
        }
    }
}

