/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.io.Resources;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;

final class ODataTemplates {
    public static final String NUGET_ROOT = ODataTemplates.load("root.nuget");
    public static final String NUGET_META = ODataTemplates.load("meta.nuget");
    public static final String NUGET_FEED = ODataTemplates.load("feed.nuget");
    public static final String NUGET_ENTRY = ODataTemplates.load("entry.nuget");
    public static final String NUGET_ERROR = ODataTemplates.load("error.nuget");
    public static final String NUGET_INLINECOUNT = ODataTemplates.load("inlinecount.nuget");
    private static final String NULL_PROPERTY = " m:null=\"true\">";

    ODataTemplates() {
    }

    public static String interpolate(String template, Map<String, ?> data) {
        int i;
        StringBuilder xml = new StringBuilder(template);
        int j = 0;
        while ((i = xml.indexOf("${", j)) > 0 && i < (j = xml.indexOf("}", i))) {
            String key;
            Object value;
            if (null != (value = data.get(key = xml.substring(i + 2, j++)))) {
                String text = value instanceof Date ? ODataUtils.datetime(((Date)value).getTime()) : value.toString();
                xml.replace(i, j, text);
                j = i + text.length();
                continue;
            }
            if (xml.charAt(--i) != '>') continue;
            xml.replace(i, j, NULL_PROPERTY);
            j = i + NULL_PROPERTY.length();
        }
        return xml.toString();
    }

    private static String load(String name) {
        try {
            return new String(Resources.toByteArray((URL)ODataUtils.class.getResource(name)), "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

