/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.h2.util.JdbcUtils;
import org.slf4j.Logger;

final class ODataResults
implements Iterator<Map<String, Object>>,
Closeable {
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Logger log;
    private final ResultSet results;
    private final String[] columns;
    private boolean hasNext;

    ODataResults(Logger log, ResultSet results, Map<String, String> extra) throws SQLException {
        this(log, null, results, extra);
    }

    ODataResults(Logger log, String[] columns, ResultSet results, Map<String, String> extra) throws SQLException {
        this.log = log;
        this.results = results;
        if (null != columns) {
            this.columns = columns;
        } else {
            ResultSetMetaData md = results.getMetaData();
            this.columns = new String[md.getColumnCount()];
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = md.getColumnName(i + 1);
            }
        }
        if (null != extra) {
            this.data.putAll(extra);
        }
    }

    public String[] getColumnNames() {
        return (String[])this.columns.clone();
    }

    @Override
    public boolean hasNext() {
        try {
            this.hasNext = this.hasNext || this.results.next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hasNext;
    }

    @Override
    public Map<String, Object> next() {
        while (this.hasNext()) {
            this.hasNext = false;
            try {
                for (int i = 0; i < this.columns.length; ++i) {
                    String key = this.columns[i];
                    Object value = this.results.getObject(i + 1);
                    if (null != value) {
                        this.data.put(key, value);
                        continue;
                    }
                    this.data.remove(key);
                }
                return this.data;
            }
            catch (Exception e) {
                this.log.warn("Problem converting OData results", (Throwable)e);
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        JdbcUtils.closeSilently((ResultSet)this.results);
    }
}

