/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.nuget.odata.H2ODataConnection;
import com.sonatype.nexus.plugins.nuget.odata.ODataNugetApiKeys;
import com.sonatype.nexus.plugins.nuget.odata.ODataNugetGallery;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.sisu.goodies.eventbus.EventBus;
import org.sonatype.sisu.goodies.lifecycle.Lifecycle;
import org.sonatype.sisu.goodies.lifecycle.internal.LifecycleManagerImpl;

@Named
@EagerSingleton
public class ODataNugetLifecycleHandler
extends LifecycleManagerImpl {
    private final EventBus eventBus;
    private final Provider<H2ODataConnection> connectionProvider;
    private final Provider<ODataNugetApiKeys> apiKeysProvider;
    private final Provider<ODataNugetGallery> galleryProvider;

    @Inject
    public ODataNugetLifecycleHandler(EventBus eventBus, Provider<H2ODataConnection> connectionProvider, Provider<ODataNugetApiKeys> apiKeysProvider, Provider<ODataNugetGallery> galleryProvider) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.connectionProvider = (Provider)Preconditions.checkNotNull(connectionProvider);
        this.apiKeysProvider = (Provider)Preconditions.checkNotNull(apiKeysProvider);
        this.galleryProvider = (Provider)Preconditions.checkNotNull(galleryProvider);
        eventBus.register((Object)this);
    }

    @Subscribe
    public void on(NexusStartedEvent event) throws Exception {
        this.add((Lifecycle)this.connectionProvider.get());
        this.add((Lifecycle)this.apiKeysProvider.get());
        this.add((Lifecycle)this.galleryProvider.get());
        this.start();
    }

    @Subscribe
    public void on(NexusStoppedEvent event) throws Exception {
        this.eventBus.unregister((Object)this);
        this.stop();
        this.clear();
    }
}

