/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.plugins.nuget.NugetGallery;
import com.sonatype.nexus.plugins.nuget.odata.MaxVersionFunction;
import com.sonatype.nexus.plugins.nuget.odata.NugetODataGalleryMigrator;
import com.sonatype.nexus.plugins.nuget.odata.ODataConnection;
import com.sonatype.nexus.plugins.nuget.odata.ODataMigrations;
import com.sonatype.nexus.plugins.nuget.odata.ODataResults;
import com.sonatype.nexus.plugins.nuget.odata.ODataTemplates;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Singleton
@Named(value="odata")
final class ODataNugetGallery
extends LifecycleSupport
implements NugetGallery {
    public static final Map<String, String> COLUMN_ALIASES = ImmutableMap.of((Object)"ISABSOLUTELATESTVERSION", (Object)"(P.VERSION=L.AV)", (Object)"ISLATESTVERSION", (Object)"(P.VERSION=L.V)");
    private static final String TABLE = "PACKAGES";
    private static final String TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS PACKAGES (REPOSITORYID                VARCHAR NOT NULL,LOCATION                    VARCHAR NOT NULL,ID               VARCHAR_IGNORECASE NOT NULL,VERSION          VARCHAR_IGNORECASE NOT NULL,AUTHORS                   VARCHAR_IGNORECASE,COPYRIGHT                 VARCHAR_IGNORECASE,CREATED                    DATETIME NOT NULL,DEPENDENCIES              VARCHAR_IGNORECASE,DESCRIPTION               VARCHAR_IGNORECASE,DOWNLOADCOUNT                  INT4 NOT NULL,GALLERYDETAILSURL         VARCHAR_IGNORECASE,ICONURL                   VARCHAR_IGNORECASE,ISPRERELEASE                   BOOL NOT NULL,LASTUPDATED                DATETIME NOT NULL,PUBLISHED                  DATETIME NOT NULL,LANGUAGE                  VARCHAR_IGNORECASE,LICENSEURL                VARCHAR_IGNORECASE,PACKAGEHASH               VARCHAR_IGNORECASE,PACKAGEHASHALGORITHM      VARCHAR_IGNORECASE,PACKAGESIZE                    INT8 NOT NULL,PROJECTURL                VARCHAR_IGNORECASE,REPORTABUSEURL            VARCHAR_IGNORECASE,RELEASENOTES              VARCHAR_IGNORECASE,REQUIRELICENSEACCEPTANCE       BOOL NOT NULL,SUMMARY                   VARCHAR_IGNORECASE,TAGS                      VARCHAR_IGNORECASE,TITLE                     VARCHAR_IGNORECASE,VERSIONDOWNLOADCOUNT           INT4 NOT NULL,PRIMARY KEY (REPOSITORYID,LOCATION) );CREATE AGGREGATE IF NOT EXISTS MAX_VERSION FOR \"" + MaxVersionFunction.class.getName() + "\";" + "CREATE INDEX IF NOT EXISTS BY_COORDS ON " + "PACKAGES" + " (ID,VERSION);" + "CREATE INDEX IF NOT EXISTS BY_POPULARITY ON " + "PACKAGES" + " (DOWNLOADCOUNT DESC,ID);" + "CREATE INDEX IF NOT EXISTS BY_TIME ON " + "PACKAGES" + " (LASTUPDATED DESC,ID);";
    private static final String UPDATE_PACKAGE = "MERGE INTO PACKAGES VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String IS_MEMBER = " LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) ";
    private static final String ISABSOLUTELATESTVERSION = ",MAX_VERSION(VERSION) AS AV";
    private static final String ISLATESTVERSION = ",MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V";
    private static final String JOIN_VERSIONS = "(SELECT ID,MAX_VERSION(VERSION) AS AV,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) GROUP BY ID) AS L INNER JOIN PACKAGES AS P ON L.ID=P.ID";
    private static final String ALL_MEMBERS = "(SELECT ID,MAX_VERSION(VERSION) AS AV,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) GROUP BY ID) AS L INNER JOIN PACKAGES AS P ON L.ID=P.ID WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) ";
    private static final String COUNT_MEMBERS = "SELECT COUNT(P.*) FROM (SELECT ID,MAX_VERSION(VERSION) AS AV,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) GROUP BY ID) AS L INNER JOIN PACKAGES AS P ON L.ID=P.ID WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) ";
    private static final String SELECT_MEMBERS = "SELECT P.*,(P.VERSION=L.AV) AS ISABSOLUTELATESTVERSION,(P.VERSION=L.V) AS ISLATESTVERSION FROM (SELECT ID,MAX_VERSION(VERSION) AS AV,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) GROUP BY ID) AS L INNER JOIN PACKAGES AS P ON L.ID=P.ID WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) ";
    private static final String ENTRY_MEMBER = "SELECT P.*,(P.VERSION=L.AV) AS ISABSOLUTELATESTVERSION,(P.VERSION=L.V) AS ISLATESTVERSION FROM (SELECT ID,MAX_VERSION(VERSION) AS AV,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS V FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) GROUP BY ID) AS L INNER JOIN PACKAGES AS P ON L.ID=P.ID WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) AND P.ID=?2 AND P.VERSION=?3";
    private static final String LOCATE_MEMBER = "SELECT LOCATION FROM PACKAGES WHERE LOCATE(CONCAT(CONCAT(':',REPOSITORYID),':'),?1) AND ID=?2 AND VERSION=?3";
    private static final String IDENTIFY_PACKAGE = "SELECT ID,VERSION FROM PACKAGES WHERE LOCATION=? LIMIT 1";
    private static final String FROM_REPO = " FROM PACKAGES WHERE REPOSITORYID=? ";
    private static final String DELETE_PACKAGE = "DELETE FROM PACKAGES WHERE REPOSITORYID=? AND LOCATION=?";
    private static final String LATEST_UPDATE = "SELECT LASTUPDATED FROM LASTUPDATES WHERE REPOSITORYID=?";
    private static final String SET_LATEST_UPDATE = "MERGE INTO LASTUPDATES VALUES (?,?)";
    private static final String DROP_REPOSITORY = "DELETE FROM PACKAGES WHERE REPOSITORYID=? ";
    public static final String WITH_NAMESPACES = " xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xmlns=\"http://www.w3.org/2005/Atom\"";
    public static final String NO_NAMESPACES = "";
    private static final String SELECT_VERSIONS = "SELECT REPOSITORYID,ID,MAX_VERSION(VERSION) AS ABSOLUTELATEST,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS LATEST FROM PACKAGES ";
    private static final String VERSIONS_SCHEMA = "CREATE INDEX IF NOT EXISTS BY_UID ON PACKAGES (REPOSITORYID,ID);CREATE TABLE IF NOT EXISTS VERSIONS (REPOSITORYID                VARCHAR NOT NULL,ID               VARCHAR_IGNORECASE NOT NULL,ABSOLUTELATEST   VARCHAR_IGNORECASE NOT NULL,LATEST           VARCHAR_IGNORECASE NOT NULL,PRIMARY KEY (REPOSITORYID,ID) ) AS SELECT REPOSITORYID,ID,MAX_VERSION(VERSION) AS ABSOLUTELATEST,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS LATEST FROM PACKAGES GROUP BY REPOSITORYID,ID;CREATE INDEX IF NOT EXISTS BY_VID ON VERSIONS (ID);DELETE FROM VERSIONS AS V WHERE NOT EXISTS (SELECT ID FROM PACKAGES AS P WHERE P.REPOSITORYID=V.REPOSITORYID AND P.ID=V.ID LIMIT 1);";
    private static final String UPDATE_VERSIONS = "MERGE INTO VERSIONS SELECT REPOSITORYID,ID,MAX_VERSION(VERSION) AS ABSOLUTELATEST,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS LATEST FROM PACKAGES WHERE REPOSITORYID=? AND ID=? GROUP BY REPOSITORYID,ID";
    private static final String DELETE_VERSIONS = "MERGE INTO VERSIONS SELECT REPOSITORYID,ID,MAX_VERSION(VERSION) AS ABSOLUTELATEST,MAX_VERSION(CASEWHEN(ISPRERELEASE,'',VERSION)) AS LATEST FROM PACKAGES WHERE REPOSITORYID=?1 AND LOCATION!=?2 AND ID=(SELECT ID FROM PACKAGES WHERE REPOSITORYID=?1 AND LOCATION=?2 LIMIT 1) GROUP BY REPOSITORYID,ID";
    private static final String DROP_VERSIONS = "DELETE FROM VERSIONS WHERE REPOSITORYID=?";
    private final ODataConnection conn;
    private final ODataMigrations migrations;
    private final NugetODataGalleryMigrator migrator;
    private final boolean useVersionsTable;
    private final int queryTimeout;
    private String[] columnNames;

    @Inject
    ODataNugetGallery(ODataConnection conn, ODataMigrations migrations, NugetODataGalleryMigrator migrator, @Named(value="${nexus-nuget-versions-table:-false}") boolean useVersionsTable, @Named(value="${nexus-nuget-query-timeout:-300}") int queryTimeout) {
        this.conn = new ODataOptimizer(conn);
        this.migrations = migrations;
        this.migrator = migrator;
        this.useVersionsTable = useVersionsTable;
        this.queryTimeout = queryTimeout;
    }

    protected void doStart() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        PreparedStatement stmt = null;
        try {
            if (this.useVersionsTable) {
                this.log.info("Enabling NuGet version table support");
                stmt = this.conn.prepare(TABLE_STATEMENT + VERSIONS_SCHEMA);
            } else {
                stmt = this.conn.prepare(TABLE_STATEMENT + "DROP TABLE IF EXISTS VERSIONS;");
            }
            stmt.executeUpdate();
            this.migrator.migrateAll(this.conn, this.migrations.getMigrations());
            Thread.currentThread().setContextClassLoader(cl);
            this.conn.close(stmt);
        }
        catch (Exception e) {
            try {
                throw new Exception("Problem preparing NuGet Gallery", e);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(cl);
                this.conn.close(stmt);
                throw throwable;
            }
        }
    }

    @Override
    public int count(Iterable<String> repositoryIds, String path, String query) {
        Integer top;
        this.log.debug("Count: " + query);
        this.ensureStarted();
        Form form = new Form(query);
        int count = this.executeCount(repositoryIds, form);
        Integer skip = OptionsQueryParser.parseSkip((String)form.getFirstValue("$skip", true));
        if (null != skip && skip >= 0) {
            count = Math.max(0, count - skip);
        }
        if (null != (top = OptionsQueryParser.parseTop((String)form.getFirstValue("$top", true))) && top >= 0) {
            count = Math.min(count, top);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCount(Iterable<String> repositoryIds, Form form) {
        PreparedStatement stmt = null;
        try {
            int count = 0;
            stmt = this.conn.prepare(ODataUtils.query(COUNT_MEMBERS, form));
            stmt.setString(1, ODataNugetGallery.membership(repositoryIds));
            stmt.setQueryTimeout(this.queryTimeout);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                count = results.getInt(1);
            }
            int n = count;
            this.conn.close(stmt);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.warn("Problem counting NuGet packages: " + form.getQueryString(CharacterSet.UTF_8) + " in: " + repositoryIds, (Throwable)e);
                int n = -1;
                this.conn.close(stmt);
                return n;
            }
            catch (Throwable throwable) {
                this.conn.close(stmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String feed(Iterable<String> repositoryIds, String base, String name, String query) {
        this.log.debug("Select: " + query);
        this.ensureStarted();
        ImmutableMap extra = ImmutableMap.of((Object)"BASEURI", (Object)base, (Object)"ENDPOINT", (Object)name, (Object)"LASTUPDATED", (Object)ODataUtils.datetime(System.currentTimeMillis()), (Object)"NAMESPACES", (Object)NO_NAMESPACES);
        StringBuilder xml = new StringBuilder();
        xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_FEED, extra));
        String revisedQuery = this.ensureQueryParameterDefault(query, "$orderby", "DownloadCount%20desc");
        Form form = new Form(revisedQuery);
        int inlineCount = this.inlineCount(repositoryIds, form);
        if (inlineCount != -1) {
            xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_INLINECOUNT, ImmutableMap.of((Object)"COUNT", (Object)String.valueOf(inlineCount))));
        }
        PreparedStatement stmt = null;
        try {
            String sqlQuery = ODataUtils.query(SELECT_MEMBERS, form);
            stmt = this.conn.prepare(sqlQuery);
            stmt.setString(1, ODataNugetGallery.membership(repositoryIds));
            stmt.setQueryTimeout(this.queryTimeout);
            ODataResults itr = this.executeODataQuery(stmt, (Map<String, String>)extra);
            int n = 1;
            while (itr.hasNext()) {
                Object data = itr.next();
                xml.append(ODataTemplates.interpolate(ODataTemplates.NUGET_ENTRY, data));
                if (n == 40) {
                    xml.append("  <link rel=\"next\" href=\"").append(base).append('/').append(name);
                    xml.append('?').append(ODataUtils.skipLink(form, data)).append("\"/>\n");
                    break;
                }
                ++n;
            }
            this.conn.close(stmt);
        }
        catch (SQLException e) {
            try {
                this.log.warn("Problem querying NuGet packages: {} in: {}", new Object[]{revisedQuery, repositoryIds, e});
                this.conn.close(stmt);
            }
            catch (Throwable throwable) {
                this.conn.close(stmt);
                throw throwable;
            }
        }
        return xml.append("</feed>").toString();
    }

    private int inlineCount(Iterable<String> repositoryIds, Form form) {
        this.log.debug("InlineCount: " + form.getQueryString(CharacterSet.UTF_8));
        InlineCount inlinecount = OptionsQueryParser.parseInlineCount((String)form.getFirstValue("$inlinecount"));
        if (inlinecount != null) {
            switch (inlinecount) {
                case ALLPAGES: {
                    return this.executeCount(repositoryIds, form);
                }
                case NONE: {
                    return -1;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String entry(Iterable<String> repositoryIds, String base, String id, String version) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(ENTRY_MEMBER);
            stmt.setString(1, ODataNugetGallery.membership(repositoryIds));
            stmt.setString(2, id);
            stmt.setString(3, version);
            ODataResults itr = this.executeODataQuery(stmt, (Map<String, String>)ImmutableMap.of((Object)"BASEURI", (Object)base, (Object)"NAMESPACES", (Object)WITH_NAMESPACES));
            if (itr.hasNext()) {
                String string = ODataTemplates.interpolate(ODataTemplates.NUGET_ENTRY, itr.next());
                return string;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem selecting NuGet package: " + id + "@" + version + " in: " + repositoryIds, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String locate(Iterable<String> repositoryIds, String id, String version) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(LOCATE_MEMBER);
            stmt.setString(1, ODataNugetGallery.membership(repositoryIds));
            stmt.setString(2, id);
            stmt.setString(3, version);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                String string = results.getString(1);
                return string;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem locating NuGet package: " + id + "@" + version + " in: " + repositoryIds, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] identify(String location) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(IDENTIFY_PACKAGE);
            stmt.setString(1, location);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                String[] stringArray = new String[]{results.getString(1), results.getString(2)};
                return stringArray;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem identifying NuGet package: " + location, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String repositoryId, Map<String, String> data) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        boolean updated = false;
        try {
            stmt = this.conn.prepare(UPDATE_PACKAGE);
            int index = 0;
            Timestamp stamp = new Timestamp(0L);
            stmt.setString(++index, repositoryId);
            stmt.setString(++index, data.get("LOCATION"));
            stmt.setString(++index, data.get("ID"));
            stmt.setString(++index, data.get("VERSION"));
            stmt.setString(++index, data.get("AUTHORS"));
            stmt.setString(++index, data.get("COPYRIGHT"));
            stamp.setTime(ODataUtils.datetime(data.get("CREATED")));
            stmt.setTimestamp(++index, stamp);
            stmt.setString(++index, data.get("DEPENDENCIES"));
            stmt.setString(++index, data.get("DESCRIPTION"));
            stmt.setInt(++index, Integer.parseInt(data.get("DOWNLOADCOUNT")));
            stmt.setString(++index, data.get("GALLERYDETAILSURL"));
            stmt.setString(++index, data.get("ICONURL"));
            stmt.setBoolean(++index, Boolean.parseBoolean(data.get("ISPRERELEASE")));
            stamp.setTime(ODataUtils.datetime(data.get("LASTUPDATED")));
            stmt.setTimestamp(++index, stamp);
            stamp.setTime(ODataUtils.datetime(data.get("PUBLISHED")));
            stmt.setTimestamp(++index, stamp);
            stmt.setString(++index, data.get("LANGUAGE"));
            stmt.setString(++index, data.get("LICENSEURL"));
            stmt.setString(++index, data.get("PACKAGEHASH"));
            stmt.setString(++index, data.get("PACKAGEHASHALGORITHM"));
            stmt.setLong(++index, Long.parseLong(data.get("PACKAGESIZE")));
            stmt.setString(++index, data.get("PROJECTURL"));
            stmt.setString(++index, data.get("REPORTABUSEURL"));
            stmt.setString(++index, data.get("RELEASENOTES"));
            stmt.setBoolean(++index, Boolean.parseBoolean(data.get("REQUIRELICENSEACCEPTANCE")));
            stmt.setString(++index, data.get("SUMMARY"));
            stmt.setString(++index, data.get("TAGS"));
            stmt.setString(++index, data.get("TITLE"));
            stmt.setInt(++index, Integer.parseInt(data.get("VERSIONDOWNLOADCOUNT")));
            updated = stmt.executeUpdate() == 1;
        }
        catch (Exception e) {
            this.log.warn("Problem updating NuGet package in: " + repositoryId, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        if (this.useVersionsTable) {
            try {
                stmt = this.conn.prepare(UPDATE_VERSIONS);
                stmt.setString(1, repositoryId);
                stmt.setString(2, data.get("ID"));
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.log.warn("Problem updating version table for: " + repositoryId, (Throwable)e);
            }
            finally {
                this.conn.close(stmt);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String repositoryId, String location) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        if (this.useVersionsTable) {
            try {
                stmt = this.conn.prepare(DELETE_VERSIONS);
                stmt.setString(1, repositoryId);
                stmt.setString(2, location);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.log.warn("Problem updating version table for: " + location + " from: " + repositoryId, (Throwable)e);
            }
            finally {
                this.conn.close(stmt);
            }
        }
        try {
            stmt = this.conn.prepare(DELETE_PACKAGE);
            stmt.setString(1, repositoryId);
            stmt.setString(2, location);
            boolean e = stmt.executeUpdate() > 0;
            return e;
        }
        catch (Exception e) {
            this.log.warn("Problem deleting NuGet package: " + location + " from: " + repositoryId, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long latestUpdate(String repositoryId) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(LATEST_UPDATE);
            stmt.setString(1, repositoryId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                long l = results.getTimestamp(1).getTime();
                return l;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem determining last update time for: " + repositoryId, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLatestUpdate(String repositoryId, long time) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(SET_LATEST_UPDATE);
            stmt.setString(1, repositoryId);
            stmt.setTimestamp(2, new Timestamp(time));
            stmt.execute();
        }
        catch (Exception e) {
            this.log.warn("Problem recording last update time for: {}", (Object)repositoryId, (Object)e);
        }
        finally {
            this.conn.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drop(String repositoryId) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        if (this.useVersionsTable) {
            try {
                stmt = this.conn.prepare(DROP_VERSIONS);
                stmt.setString(1, repositoryId);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.log.warn("Problem updating version table for: " + repositoryId, (Throwable)e);
            }
            finally {
                this.conn.close(stmt);
            }
        }
        try {
            stmt = this.conn.prepare(DROP_REPOSITORY);
            stmt.setString(1, repositoryId);
            int e = stmt.executeUpdate();
            return e;
        }
        catch (Exception e) {
            this.log.warn("Problem dropping NuGet repository: " + repositoryId, (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return 0;
    }

    private String ensureQueryParameterDefault(@Nullable String query, String parameter, String defaultValue) {
        if (query == null) {
            return parameter + "=" + defaultValue;
        }
        if (!query.contains(parameter)) {
            return parameter + "=" + defaultValue + "&" + query;
        }
        return query;
    }

    private ODataResults executeODataQuery(PreparedStatement stmt, Map<String, String> extra) throws SQLException {
        ODataResults results = new ODataResults(this.log, this.columnNames, stmt.executeQuery(), extra);
        if (null == this.columnNames) {
            this.columnNames = results.getColumnNames();
        }
        return results;
    }

    private static String membership(Iterable<String> repositoryIds) {
        StringBuilder buf = new StringBuilder();
        for (String id : repositoryIds) {
            buf.append(':').append(id);
        }
        return buf.append(':').toString();
    }

    private final class ODataOptimizer
    implements ODataConnection {
        private final ODataConnection conn;

        ODataOptimizer(ODataConnection conn) {
            this.conn = conn;
        }

        @Override
        public PreparedStatement prepare(String sql) {
            boolean skipLatestVersion;
            String optimizedSQL = sql;
            boolean skipAbsoluteVersion = !sql.contains("(P.VERSION=L.AV)");
            boolean bl = skipLatestVersion = !sql.contains("(P.VERSION=L.V)");
            if (skipAbsoluteVersion && skipLatestVersion) {
                optimizedSQL = optimizedSQL.replace(ODataNugetGallery.JOIN_VERSIONS, "PACKAGES AS P");
            } else if (skipAbsoluteVersion) {
                optimizedSQL = optimizedSQL.replace(ODataNugetGallery.ISABSOLUTELATESTVERSION, ODataNugetGallery.NO_NAMESPACES);
            } else if (skipLatestVersion) {
                optimizedSQL = optimizedSQL.replace(ODataNugetGallery.ISLATESTVERSION, ODataNugetGallery.NO_NAMESPACES);
            }
            if (ODataNugetGallery.this.useVersionsTable && sql.contains(ODataNugetGallery.JOIN_VERSIONS)) {
                optimizedSQL = optimizedSQL.replaceFirst("PACKAGES WHERE", "VERSIONS WHERE");
                optimizedSQL = optimizedSQL.replace(ODataNugetGallery.ISABSOLUTELATESTVERSION, ",MAX_VERSION(ABSOLUTELATEST) AS AV");
                optimizedSQL = optimizedSQL.replace(ODataNugetGallery.ISLATESTVERSION, ",MAX_VERSION(LATEST) AS V");
            }
            return this.conn.prepare(optimizedSQL);
        }

        @Override
        public void close(PreparedStatement stmt) {
            this.conn.close(stmt);
        }
    }
}

