/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.base.Charsets;
import com.sonatype.nexus.plugins.nuget.odata.ODataConnection;
import com.sonatype.nexus.plugins.nuget.security.NugetApiKeyStore;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Singleton
@Named(value="odata")
final class ODataNugetApiKeys
extends LifecycleSupport
implements NugetApiKeyStore {
    private static final String TABLE = "PRINCIPALS";
    private static final String TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS PRINCIPALS (ID VARCHAR NOT NULL, PRINCIPALS OTHER NOT NULL, APIKEY VARCHAR NOT NULL, PRIMARY KEY (ID));";
    private static final String SET_PRINCIPALS = "MERGE INTO PRINCIPALS VALUES (?,?,?)";
    private static final String GET_PRINCIPALS = "SELECT PRINCIPALS FROM PRINCIPALS WHERE APIKEY=?";
    private static final String GET_APIKEY = "SELECT APIKEY FROM PRINCIPALS WHERE ID=?";
    private static final String DELETE_PRINCIPALS = "DELETE FROM PRINCIPALS WHERE ID=?";
    private static final String GET_ALL_PRINCIPALS = "SELECT PRINCIPALS FROM PRINCIPALS";
    private final ODataConnection conn;
    private final Random random = new Random();
    private final UserPrincipalsHelper principalsHelper;

    @Inject
    ODataNugetApiKeys(ODataConnection conn, UserPrincipalsHelper principalsHelper) {
        this.conn = conn;
        this.principalsHelper = principalsHelper;
    }

    protected void doStart() throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(TABLE_STATEMENT);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new Exception("Problem preparing NuGet API-Keys", e);
        }
        finally {
            this.conn.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] createApiKey(PrincipalCollection principals) {
        this.ensureStarted();
        String salt = new BigInteger(32, this.random).toString(32);
        byte[] code = ("~NuGet~" + principals + salt).getBytes(Charsets.UTF_8);
        String apiKey = UUID.nameUUIDFromBytes(code).toString();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(SET_PRINCIPALS);
            stmt.setString(1, principals.getPrimaryPrincipal().toString());
            stmt.setObject(2, principals);
            stmt.setString(3, apiKey);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            this.log.warn("Problem creating NuGet API-Key", (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return apiKey.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getApiKey(PrincipalCollection principals) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(GET_APIKEY);
            stmt.setString(1, principals.getPrimaryPrincipal().toString());
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                char[] cArray = results.getString(1).toCharArray();
                return cArray;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem retrieving NuGet API-Key", (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalCollection getPrincipals(char[] apiKey) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(GET_PRINCIPALS);
            stmt.setString(1, new String(apiKey));
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                PrincipalCollection principalCollection = (PrincipalCollection)results.getObject(1);
                return principalCollection;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem verifying NuGet API-Key", (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApiKey(PrincipalCollection principals) {
        this.ensureStarted();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(DELETE_PRINCIPALS);
            stmt.setString(1, principals.getPrimaryPrincipal().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            this.log.warn("Problem deleting NuGet API-Key", (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeApiKeys() {
        this.ensureStarted();
        ArrayList<PrincipalCollection> principalsToRemove = new ArrayList<PrincipalCollection>();
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepare(GET_ALL_PRINCIPALS);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                PrincipalCollection principals = (PrincipalCollection)results.getObject(1);
                try {
                    this.principalsHelper.getUserStatus(principals);
                }
                catch (UserNotFoundException e) {
                    principalsToRemove.add(principals);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Problem purging NuGet API-Keys", (Throwable)e);
        }
        finally {
            this.conn.close(stmt);
        }
        for (PrincipalCollection principals : principalsToRemove) {
            this.deleteApiKey(principals);
        }
    }
}

