/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.sonatype.nexus.plugins.nuget.odata.ODataUtils;
import com.sonatype.nexus.plugins.nuget.odata.XmlSplicer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.item.StorageFileItem;

public final class NuspecSplicer
extends XmlSplicer {
    private static final List<String> ACCEPTED_TAGS = ImmutableList.of((Object)"id", (Object)"version", (Object)"authors", (Object)"description", (Object)"title", (Object)"releaseNotes", (Object)"summary", (Object)"tags", (Object)"projectUrl", (Object)"iconUrl", (Object)"licenseUrl", (Object)"copyright", (Object[])new String[]{"requireLicenseAcceptance"});
    final Map<String, String> data = new HashMap<String, String>();

    NuspecSplicer() {
        super(new StringBuilder());
    }

    public static Map<String, String> header(InputStream is) throws XmlPullParserException, IOException {
        NuspecSplicer splicer = new NuspecSplicer();
        byte[] nuspec = NuspecSplicer.extractNuspec(is, null);
        splicer.consume((Reader)ReaderFactory.newXmlReader((InputStream)new ByteArrayInputStream(nuspec)));
        return splicer.data;
    }

    public static Map<String, String> consumeItem(StorageFileItem item) throws XmlPullParserException, IOException {
        byte[] digest = new byte[64];
        NuspecSplicer splicer = new NuspecSplicer();
        byte[] nuspec = NuspecSplicer.extractNuspec(item.getInputStream(), digest);
        splicer.consume((Reader)ReaderFactory.newXmlReader((InputStream)new ByteArrayInputStream(nuspec)));
        return splicer.populateItemData(item, digest);
    }

    @Override
    void started(String name, int len, boolean isRoot) throws XmlPullParserException {
        if (isRoot && !"package".equals(name)) {
            throw new XmlPullParserException("Parsed xml has an unexpected start tag: '" + name + "' (expected 'package')");
        }
        if ("dependency".equals(name)) {
            String deps = this.data.get("DEPENDENCIES");
            String d = this.getAttribute("id") + ':' + this.getAttribute("version");
            this.data.put("DEPENDENCIES", null == deps ? d : deps + '|' + d);
        }
        this.xml.setLength(0);
    }

    @Override
    void ended(String name, int len) {
        if (ACCEPTED_TAGS.contains(name)) {
            this.data.put(name.toUpperCase(Locale.ENGLISH), this.xml.substring(0, this.xml.length() - len));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] extractNuspec(InputStream is, byte[] digest) throws LocalStorageException {
        try {
            MessageDigest message = null;
            InputStream dis = is;
            if (null != digest) {
                message = MessageDigest.getInstance("SHA-512");
                dis = new DigestInputStream(is, message);
            }
            try (ZipInputStream zis = new ZipInputStream(dis);){
                ZipEntry e = zis.getNextEntry();
                while (e != null) {
                    if (e.getName().endsWith(".nuspec")) {
                        byte[] nuspec = ByteStreams.toByteArray((InputStream)zis);
                        if (null != digest && null != message) {
                            ByteStreams.copy((InputStream)dis, (OutputStream)ByteStreams.nullOutputStream());
                            message.digest(digest, 0, digest.length);
                        }
                        byte[] byArray = nuspec;
                        return byArray;
                    }
                    e = zis.getNextEntry();
                }
                throw new LocalStorageException("Missing nuspec");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new LocalStorageException((Throwable)e);
        }
    }

    private Map<String, String> populateItemData(StorageFileItem item, byte[] digest) throws XmlPullParserException {
        String id = this.data.get("ID");
        if (null == id || id.length() == 0) {
            throw new XmlPullParserException("Missing id");
        }
        String version = this.data.get("VERSION");
        if (null == version || version.length() == 0) {
            throw new XmlPullParserException("Missing version");
        }
        if (version.contains("-")) {
            this.data.put("ISPRERELEASE", "true");
        }
        this.data.put("CREATED", ODataUtils.datetime(item.getCreated()));
        this.data.put("LASTUPDATED", ODataUtils.datetime(item.getModified()));
        this.data.put("PUBLISHED", ODataUtils.datetime(item.getModified()));
        this.data.put("PACKAGESIZE", String.valueOf(item.getLength()));
        this.data.put("PACKAGEHASH", new String(Base64.encodeBase64((byte[])digest), Charsets.UTF_8));
        this.data.put("PACKAGEHASHALGORITHM", "SHA512");
        this.data.put("LOCATION", ODataUtils.toSQL(item.getRepositoryItemUid()));
        if (!this.data.containsKey("TITLE")) {
            this.data.put("TITLE", id);
        }
        if (!this.data.containsKey("SUMMARY")) {
            this.data.put("SUMMARY", this.data.get("DESCRIPTION"));
        }
        if (!this.data.containsKey("REQUIRELICENSEACCEPTANCE")) {
            this.data.put("REQUIRELICENSEACCEPTANCE", "false");
        }
        this.data.put("VERSIONDOWNLOADCOUNT", "0");
        this.data.put("DOWNLOADCOUNT", "0");
        return this.data;
    }
}

