/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.base.Throwables;
import com.sonatype.nexus.plugins.nuget.odata.ODataConnection;
import com.sonatype.nexus.plugins.nuget.odata.ODataMigration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NugetODataGalleryMigrator {
    private static final String CREATE_VERSION_HISTORY = "CREATE TABLE IF NOT EXISTS VERSION_HISTORY(VERSION INT PRIMARY KEY, DATE_APPLIED TIMESTAMP)";
    private static final String INSERT_VERSION_HISTORY = "INSERT INTO VERSION_HISTORY (VERSION, DATE_APPLIED) VALUES (?, NOW())";
    private static final String SELECT_LATEST_VERSION = "SELECT MAX(VERSION) FROM VERSION_HISTORY";
    private static final Logger log = LoggerFactory.getLogger(NugetODataGalleryMigrator.class);

    public void migrateAll(ODataConnection connection, List<ODataMigration> migrations) throws SQLException {
        log.info("Starting Nuget DB migration.");
        for (ODataMigration migration : migrations) {
            int databaseCurrentVersion = this.getCurrentVersion(connection);
            if (migration.getVersion() <= databaseCurrentVersion) continue;
            log.info("Starting Nuget DB migration to version {}", (Object)migration.getVersion());
            try {
                migration.migrate(connection);
            }
            catch (Exception e) {
                log.error("Error while migrating Nuget DB to version {}", (Object)migration.getVersion(), (Object)e);
                Throwables.propagate((Throwable)e);
            }
            this.updateCurrentVersion(connection, migration.getVersion());
            log.info("Completed Nuget DB migration to version {}", (Object)migration.getVersion());
        }
        log.info("Completed Nuget DB migration.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentVersion(ODataConnection connection) throws SQLException {
        PreparedStatement createTable = connection.prepare(CREATE_VERSION_HISTORY);
        try {
            createTable.execute();
        }
        finally {
            connection.close(createTable);
        }
        PreparedStatement queryCurrentVersion = connection.prepare(SELECT_LATEST_VERSION);
        try {
            ResultSet resultSet = queryCurrentVersion.executeQuery();
            if (!resultSet.next()) {
                int n = -1;
                return n;
            }
            int anInt = resultSet.getInt(1);
            if (resultSet.wasNull()) {
                int n = -1;
                return n;
            }
            int n = anInt;
            return n;
        }
        finally {
            connection.close(queryCurrentVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentVersion(ODataConnection connection, int version) throws SQLException {
        PreparedStatement update = connection.prepare(INSERT_VERSION_HISTORY);
        try {
            update.setInt(1, version);
            update.execute();
        }
        finally {
            connection.close(update);
        }
    }
}

