/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import java.sql.Connection;
import org.h2.api.AggregateFunction;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;

public final class MaxVersionFunction
implements AggregateFunction {
    private static final VersionScheme SCHEME = new GenericVersionScheme();
    private Version maxVersion;

    public void init(Connection conn) {
        this.maxVersion = null;
    }

    public int getType(int[] inputTypes) {
        return 12;
    }

    public void add(Object value) {
        try {
            Version version = SCHEME.parseVersion((String)value);
            if (null == this.maxVersion || this.maxVersion.compareTo((Object)version) < 0) {
                this.maxVersion = version;
            }
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            // empty catch block
        }
    }

    public Object getResult() {
        return this.maxVersion.toString();
    }
}

