/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.odata;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.sonatype.nexus.plugins.nuget.odata.ODataConnection;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.h2.Driver;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.util.JdbcUtils;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Singleton
@Named(value="h2")
final class H2ODataConnection
extends LifecycleSupport
implements ODataConnection {
    static final String H2_DEFAULTS = ";FILE_LOCK=FS;QUERY_CACHE_SIZE=0;CACHE_SIZE=0;CACHE_TYPE=SOFT_LRU;MULTI_THREADED=1;LOCK_TIMEOUT=60000;MAX_MEMORY_ROWS=1000000";
    static final String H2_SETTINGS = "${nexus-nuget-h2-settings:-;FILE_LOCK=FS;QUERY_CACHE_SIZE=0;CACHE_SIZE=0;CACHE_TYPE=SOFT_LRU;MULTI_THREADED=1;LOCK_TIMEOUT=60000;MAX_MEMORY_ROWS=1000000}";
    private static final String DATABASE_NAME = "odata";
    private final ApplicationConfiguration cfg;
    private final String settings;
    private JdbcConnectionPool pool;

    @Inject
    H2ODataConnection(ApplicationConfiguration cfg, @Named(value="${nexus-nuget-h2-settings:-;FILE_LOCK=FS;QUERY_CACHE_SIZE=0;CACHE_SIZE=0;CACHE_TYPE=SOFT_LRU;MULTI_THREADED=1;LOCK_TIMEOUT=60000;MAX_MEMORY_ROWS=1000000}") String settings) {
        this.cfg = cfg;
        this.settings = settings;
    }

    protected void doStart() throws Exception {
        block11: {
            if (null != this.pool) {
                return;
            }
            File workDir = this.cfg.getWorkingDirectory("nuget").getAbsoluteFile();
            DirSupport.mkdir((Path)workDir.toPath());
            String database = workDir + File.separator + DATABASE_NAME;
            File databaseFile = new File(database + ".h2.db");
            try {
                try {
                    this.pool = H2ODataConnection.open(database, this.settings);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 90020 || Strings.nullToEmpty((String)e.getMessage()).contains("Database may be already in use")) {
                        File lockFile;
                        this.log.warn("Database locked, is another instance of Nexus running? ({})", (Object)e.getMessage());
                        File backup = new File(workDir, "odata.backup." + System.currentTimeMillis());
                        if (databaseFile.exists()) {
                            this.log.info("Backing up locked database to {} to limit potential corruption", (Object)backup);
                            Files.move((File)databaseFile, (File)backup);
                            Files.copy((File)backup, (File)databaseFile);
                        }
                        if ((lockFile = new File(database + ".lock.db")).exists()) {
                            Files.move((File)lockFile, (File)new File(backup.getPath() + ".lock"));
                        }
                        this.pool = H2ODataConnection.open(database, this.settings);
                        break block11;
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                this.log.warn("Database corrupt, starting with empty NuGet DB ({})", (Object)e.getMessage());
                try {
                    File backup = new File(workDir, "odata.corrupt." + System.currentTimeMillis());
                    this.log.info("Moving corrupt database to {}", (Object)backup);
                    Files.move((File)databaseFile, (File)backup);
                    this.pool = H2ODataConnection.open(database, this.settings);
                }
                catch (Exception ignore) {
                    throw new Exception("Problem rebooting NuGet DB", e);
                }
            }
            catch (Exception e) {
                throw new Exception("Problem starting NuGet DB", e);
            }
        }
    }

    protected void doStop() throws Exception {
        if (null != this.pool) {
            try {
                this.pool.dispose();
            }
            finally {
                this.pool = null;
                Driver.unload();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PreparedStatement prepare(String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close(PreparedStatement stmt) {
        try {
            JdbcUtils.closeSilently((Connection)stmt.getConnection());
        }
        catch (Exception exception) {
        }
        finally {
            JdbcUtils.closeSilently((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JdbcConnectionPool open(String database, String settings) throws Exception {
        JdbcConnectionPool pool = null;
        try {
            Driver.load();
            String url = "jdbc:h2:" + database + (settings.startsWith(";") ? settings : ';' + settings);
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(url, "sa", "");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(conn);
                throw throwable;
            }
            JdbcUtils.closeSilently((Connection)conn);
            pool = JdbcConnectionPool.create((String)url, (String)"sa", (String)"");
            pool.setMaxConnections(8);
            return pool;
        }
        catch (Exception e) {
            if (null != pool) {
                pool.dispose();
            }
            throw e;
        }
    }
}

