/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.group;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.nuget.group.NugetGroupRepositoryConfiguration;
import com.sonatype.nexus.plugins.nuget.group.NugetGroupRepositoryConfigurator;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractGroupRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;

@Named(value="nuget-group")
@Typed(value={GroupRepository.class})
public final class NugetGroupRepository
extends AbstractGroupRepository
implements GroupRepository {
    public static final String ROLE_HINT = "nuget-group";
    private final ContentClass contentClass;
    private final NugetGroupRepositoryConfigurator configurator;
    private final RepositoryKind repositoryKind = new DefaultRepositoryKind(GroupRepository.class, null);

    @Inject
    public NugetGroupRepository(@Named(value="nuget") ContentClass contentClass, NugetGroupRepositoryConfigurator configurator) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NugetGroupRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NugetGroupRepositoryConfiguration>(){

            public NugetGroupRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NugetGroupRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }
}

