/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget.feed;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.sonatype.nexus.plugins.nuget.odata.FeedSplicer;
import com.sonatype.nexus.plugins.nuget.odata.ODataConsumer;
import com.sonatype.nexus.plugins.nuget.proxy.NugetProxyRepository;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.sisu.goodies.common.SimpleFormat;

@Named
public class NugetFeedFetcher {
    private static final Logger log = LoggerFactory.getLogger(NugetFeedFetcher.class);

    @Nullable
    public Integer cachePackageFeed(NugetProxyRepository proxy, String query, int retries, boolean follow, ODataConsumer odataConsumer) throws Exception {
        Preconditions.checkNotNull((Object)proxy);
        Preconditions.checkNotNull((Object)query);
        ResourceStoreRequest rsr = new ResourceStoreRequest(query);
        FeedSplicer splicer = new FeedSplicer(odataConsumer);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        String baseUrl = proxy.getGalleryUrl();
        do {
            StorageItem item = this.getStorageItem(proxy, rsr, baseUrl, retries);
            baseUrl = null;
            try (InputStream is = ((StorageFileItem)item).getInputStream();){
                String next = splicer.consumePage(is);
                if (!follow || next == null) continue;
                if (visited.add(next)) {
                    baseUrl = next;
                    rsr.setRequestPath("/");
                    URL nextUrl = new URL(next);
                    if (!StringUtils.isNotBlank((String)nextUrl.getFile())) continue;
                    baseUrl = next.substring(0, next.length() - nextUrl.getFile().length());
                    rsr.setRequestPath(nextUrl.getFile());
                    continue;
                }
                log.warn("Page cycle detected: {} -> {}", visited, (Object)next);
            }
        } while (null != baseUrl);
        return splicer.getCount();
    }

    @Nullable
    public Integer getCount(NugetProxyRepository proxy, String query) throws Exception {
        StorageItem item = this.getStorageItem(proxy, new ResourceStoreRequest(query), proxy.getGalleryUrl(), 1);
        try (InputStream is = ((StorageFileItem)item).getInputStream();){
            String s = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8)).trim();
            Integer n = Integer.parseInt(s);
            return n;
        }
    }

    private StorageItem getStorageItem(NugetProxyRepository proxy, ResourceStoreRequest rsr, String baseUrl, int tries) throws ItemNotFoundException, RemoteStorageException {
        log.debug("Retrieving {}, number of retries: {}", (Object)rsr, (Object)tries);
        int count = 0;
        Throwable lastThrown = null;
        while (count < tries) {
            try {
                return proxy.getRemoteStorage().retrieveItem((ProxyRepository)proxy, rsr, baseUrl);
            }
            catch (ItemNotFoundException | RemoteStorageException e) {
                lastThrown = e;
                if (++count >= tries) continue;
                log.debug("Could not retrieve {} due to {}/{}. Retrying {} more time(s)", new Object[]{rsr, lastThrown.getClass().getSimpleName(), lastThrown.getMessage(), tries - count});
            }
        }
        Throwables.propagateIfInstanceOf(lastThrown, ItemNotFoundException.class);
        Throwables.propagateIfInstanceOf((Throwable)lastThrown, RemoteStorageException.class);
        throw new ItemNotFoundException(new ItemNotFoundException.ItemNotFoundReason(SimpleFormat.template((String)"Could not download feed", (Object[])new Object[0]), rsr));
    }
}

