/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.nuget;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.proxy.ResourceStoreRequest;

public final class NugetStoreRequest
extends ResourceStoreRequest {
    private static final Pattern NUGET_REPO_PATTERN = Pattern.compile("(.*/)?([^/]+)/([^/]+)/\\2-\\3.nupkg");
    private final String id;
    private final String version;

    public NugetStoreRequest(String id, String version, boolean localOnly, boolean remoteOnly) {
        super('/' + id + '/' + version + '/' + id + '-' + version + ".nupkg", localOnly, remoteOnly);
        this.id = id;
        this.version = version;
    }

    public NugetStoreRequest(String path, boolean localOnly, boolean remoteOnly) {
        super(path, localOnly, remoteOnly);
        Matcher matcher = NUGET_REPO_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(path + " does not represent a NuGet package!");
        }
        this.id = matcher.group(2);
        this.version = matcher.group(3);
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }
}

