/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal.mappers;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.sonatype.sisu.siesta.server.ErrorExceptionMapperSupport;

@Named
@Singleton
public class WebApplicationExceptionMapper
extends ErrorExceptionMapperSupport<WebApplicationException> {
    private Provider<UriInfo> uriInfoProvider;

    @Override
    protected int getStatusCode(WebApplicationException exception) {
        return exception.getResponse().getStatus();
    }

    @Override
    protected String getMessage(WebApplicationException exception) {
        Response.Status status;
        if (Response.Status.NOT_FOUND.getStatusCode() == exception.getResponse().getStatus()) {
            return "No resource available at '" + this.getUriInfo().getPath() + "'";
        }
        if (405 == exception.getResponse().getStatus()) {
            return this.getRequest().getMethod() + " method not allowed on resource '" + this.getUriInfo().getPath() + "'";
        }
        String message = super.getMessage(exception);
        if (message == null && (status = Response.Status.fromStatusCode((int)exception.getResponse().getStatus())) != null) {
            return status.getStatusCode() + " " + status.getReasonPhrase();
        }
        return message;
    }

    @Inject
    public void installUriInfoProvider(Provider<UriInfo> uriInfoProvider) {
        this.uriInfoProvider = (Provider)Preconditions.checkNotNull(uriInfoProvider);
    }

    protected UriInfo getUriInfo() {
        Preconditions.checkState((this.uriInfoProvider != null ? 1 : 0) != 0, (Object)"UriInfo provider not installed");
        return (UriInfo)this.uriInfoProvider.get();
    }
}

