/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal.mappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorXO;
import org.sonatype.sisu.siesta.server.ValidationErrorsExceptionMappersSupport;

@Named
@Singleton
public class ConstraintViolationExceptionMapper
extends ValidationErrorsExceptionMappersSupport<ConstraintViolationException> {
    @Override
    protected List<ValidationErrorXO> getValidationErrors(ConstraintViolationException exception) {
        return this.getValidationErrors(exception.getConstraintViolations());
    }

    @Override
    protected int getStatusCode(ConstraintViolationException exception) {
        return this.getResponseStatus(exception.getConstraintViolations()).getStatusCode();
    }

    @Override
    private List<ValidationErrorXO> getValidationErrors(Set<ConstraintViolation<?>> violations) {
        ArrayList<ValidationErrorXO> errors = new ArrayList<ValidationErrorXO>();
        for (ConstraintViolation<?> violation : violations) {
            errors.add(new ValidationErrorXO(this.getPath(violation), violation.getMessage()));
        }
        return errors;
    }

    private Response.Status getResponseStatus(Set<ConstraintViolation<?>> constraintViolations) {
        Iterator<ConstraintViolation<?>> iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            return this.getResponseStatus(iterator.next());
        }
        return Response.Status.BAD_REQUEST;
    }

    private Response.Status getResponseStatus(ConstraintViolation<?> constraintViolation) {
        for (Path.Node node : constraintViolation.getPropertyPath()) {
            ElementKind kind = node.getKind();
            if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.BAD_REQUEST;
    }

    private String getPath(ConstraintViolation violation) {
        String leafBeanName = violation.getLeafBean().getClass().getSimpleName();
        String propertyPath = violation.getPropertyPath().toString();
        return leafBeanName + (!"".equals(propertyPath) ? '.' + propertyPath : "");
    }
}

