/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SisuComponentProviderFactory
implements IoCComponentProviderFactory {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BeanLocator container;

    @Inject
    public SisuComponentProviderFactory(BeanLocator container) {
        this.container = (BeanLocator)Preconditions.checkNotNull((Object)container);
        this.log.debug("Container: {}", (Object)container);
    }

    public IoCComponentProvider getComponentProvider(Class<?> type) {
        Preconditions.checkNotNull(type);
        this.log.trace("Get component provider: {}", type);
        Iterator iter = this.container.locate(Key.get(type)).iterator();
        if (iter.hasNext()) {
            final BeanEntry entry = (BeanEntry)iter.next();
            this.log.trace("Found component: {}", (Object)entry);
            return new IoCInstantiatedComponentProvider(){

                public Object getInjectableInstance(Object obj) {
                    return obj;
                }

                public Object getInstance() {
                    return entry.getValue();
                }
            };
        }
        return null;
    }

    public IoCComponentProvider getComponentProvider(ComponentContext context, Class<?> type) {
        return this.getComponentProvider(type);
    }
}

