/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal.jersey;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerNotifier;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.container.servlet.WebServletConfig;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.siesta.server.ApplicationContainer;

@Named
public class JerseyContainer
extends ServletContainer
implements ApplicationContainer,
ContainerNotifier {
    private static final Logger log = LoggerFactory.getLogger(JerseyContainer.class);
    private final List<ContainerListener> listeners = Lists.newArrayList();
    private final IoCComponentProviderFactory componentProviderFactory;
    private ResourceConfig resourceConfig;
    private WebApplication webApplication;

    @Inject
    public JerseyContainer(IoCComponentProviderFactory componentProviderFactory) throws Exception {
        this.componentProviderFactory = (IoCComponentProviderFactory)Preconditions.checkNotNull((Object)componentProviderFactory);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        DefaultResourceConfig config = new DefaultResourceConfig();
        config.getSingletons().add(new DummyResource());
        return config;
    }

    public WebApplication getWebApplication() {
        return this.webApplication;
    }

    protected void initiate(ResourceConfig config, WebApplication webApp) {
        this.resourceConfig = (ResourceConfig)Preconditions.checkNotNull((Object)config);
        this.webApplication = webApp;
        webApp.initiate(config, this.componentProviderFactory);
    }

    public void init() throws ServletException {
        this.init((WebConfig)new WebServletConfig(this){

            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                Preconditions.checkNotNull(props);
                props.put("com.sun.jersey.spi.container.ContainerNotifier", JerseyContainer.this);
                props.put("com.sun.jersey.config.feature.XmlRootElementProcessing", Boolean.TRUE.toString());
                return super.getDefaultResourceConfig(props);
            }
        });
    }

    public void addListener(ContainerListener listener) {
        Preconditions.checkNotNull((Object)listener);
        log.trace("Adding listener: {}", (Object)listener);
        this.listeners.add(listener);
    }

    @Override
    public void add(Application application) {
        Preconditions.checkNotNull((Object)application);
        Preconditions.checkState((this.resourceConfig != null ? 1 : 0) != 0);
        log.trace("Adding application: {}", (Object)application);
        assert (this.resourceConfig != null);
        this.resourceConfig.add(application);
        for (ContainerListener listener : this.listeners) {
            listener.onReload();
        }
    }

    @Path(value="internal-dummy-root-resource-for-jersey")
    private static class DummyResource {
        private DummyResource() {
        }
    }
}

